% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionSurv.R
\name{autoplot.PredictionSurv}
\alias{autoplot.PredictionSurv}
\title{Plot for PredictionSurv}
\usage{
\method{autoplot}{PredictionSurv}(
  object,
  type = "calib",
  task = NULL,
  row_ids = NULL,
  times = NULL,
  ...
)
}
\arguments{
\item{object}{(\link[mlr3proba:PredictionSurv]{mlr3proba::PredictionSurv}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{task}{(\link[mlr3proba:TaskSurv]{mlr3proba::TaskSurv}) \cr
If \code{type = "calib"} then \code{task} is passed to \verb{$predict} in the Kaplan-Meier learner.}

\item{row_ids}{(\code{integer()}) \cr
If \code{type = "calib"} then \code{row_ids} is passed to \verb{$predict} in the Kaplan-Meier learner.}

\item{times}{(\code{numeric()}) \cr
If \code{type = "calib"} then \code{times} is the values on the x-axis to plot over,
if \code{NULL} uses all times from \code{task}.}

\item{...}{(\code{any}):
Additional arguments, currently unused.}
}
\description{
Generates plots for \link[mlr3proba:PredictionSurv]{mlr3proba::PredictionSurv}, depending on argument \code{type}:
\itemize{
\item \code{"calib"} (default): Calibration plot comparing the average predicted survival distribution
to a Kaplan-Meier prediction, this is \emph{not} a comparison of a stratified \code{crank} or \code{lp}
prediction. \code{object} must have \code{distr} prediction. \code{geom_line()} is used for comparison split
between the prediction (\code{Pred}) and Kaplan-Meier estimate (\code{KM}). In addition labels are added
for the x (\code{T}) and y (\code{S(T)}) axes.
}
}
\examples{
library(mlr3)
library(mlr3proba)
library(mlr3viz)

learn = lrn("surv.coxph")
task = tsk("rats")
p = learn$train(task, row_ids = 1:100)$predict(task, row_ids = 101:200)
autoplot(p, type = "calib", task = task)
}
