% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchCallback.R
\name{torch_callback}
\alias{torch_callback}
\title{Create a Callback Desctiptor}
\usage{
torch_callback(
  id,
  classname = paste0("CallbackSet", capitalize(id)),
  param_set = NULL,
  packages = NULL,
  label = capitalize(id),
  man = NULL,
  on_begin = NULL,
  on_end = NULL,
  on_exit = NULL,
  on_epoch_begin = NULL,
  on_before_valid = NULL,
  on_epoch_end = NULL,
  on_batch_begin = NULL,
  on_batch_end = NULL,
  on_after_backward = NULL,
  on_batch_valid_begin = NULL,
  on_batch_valid_end = NULL,
  on_valid_end = NULL,
  state_dict = NULL,
  load_state_dict = NULL,
  initialize = NULL,
  public = NULL,
  private = NULL,
  active = NULL,
  parent_env = parent.frame(),
  inherit = CallbackSet,
  lock_objects = FALSE
)
}
\arguments{
\item{id}{(\code{character(1)})\cr`\cr
The id for the torch callback.}

\item{classname}{(\code{character(1)})\cr
The class name.}

\item{param_set}{(\code{ParamSet})\cr
The parameter set, if not present it is inferred from the \verb{$initialize()} method.}

\item{packages}{(\code{character()})\cr\verb{The packages the callback depends on. Default is}NULL`.}

\item{label}{(\code{character(1)})\cr
The label for the torch callback.
Defaults to the capitalized \code{id}.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.
The default is \code{NULL}.}

\item{on_begin, on_end, on_epoch_begin, on_before_valid, on_epoch_end, on_batch_begin, on_batch_end, on_after_backward, on_batch_valid_begin, on_batch_valid_end, on_valid_end, on_exit}{(\code{function})\cr
Function to execute at the given stage, see section \emph{Stages}.}

\item{state_dict}{(\verb{function()})\cr
The function that retrieves the state dict from the callback.
This is what will be available in the learner after training.}

\item{load_state_dict}{(\verb{function(state_dict)})\cr
Function that loads a callback state.}

\item{initialize}{(\verb{function()})\cr
The initialization method of the callback.}

\item{public, private, active}{(\code{list()})\cr
Additional public, private, and active fields to add to the callback.}

\item{parent_env}{(\code{environment()})\cr
The parent environment for the \code{\link[R6:R6Class]{R6Class}}.}

\item{inherit}{(\code{R6ClassGenerator})\cr
From which class to inherit.
This class must either be \code{\link{CallbackSet}} (default) or inherit from it.}

\item{lock_objects}{(\code{logical(1)})\cr
Whether to lock the objects of the resulting \code{\link[R6:R6Class]{R6Class}}.
If \code{FALSE} (default), values can be freely assigned to \code{self} without declaring them in the
class definition.}
}
\value{
\code{\link{TorchCallback}}
}
\description{
Convenience function to create a custom \code{\link{TorchCallback}}.
All arguments that are available in \code{\link[=callback_set]{callback_set()}} are also available here.
For more information on how to correctly implement a new callback, see \code{\link{CallbackSet}}.
}
\section{Internals}{

It first creates an \code{R6} class inheriting from \code{\link{CallbackSet}} (using \code{\link[=callback_set]{callback_set()}}) and
then wraps this generator in a \code{\link{TorchCallback}} that can be passed to a torch learner.
}

\section{Stages}{

\itemize{
\item \code{begin} :: Run before the training loop begins.
\item \code{epoch_begin} :: Run he beginning of each epoch.
\item \code{batch_begin} :: Run before the forward call.
\item \code{after_backward} :: Run after the backward call.
\item \code{batch_end} :: Run after the optimizer step.
\item \code{batch_valid_begin} :: Run before the forward call in the validation loop.
\item \code{batch_valid_end} :: Run after the forward call in the validation loop.
\item \code{valid_end} :: Run at the end of validation.
\item \code{epoch_end} :: Run at the end of each epoch.
\item \code{end} :: Run after last epoch.
\item \code{exit} :: Run at last, using \code{on.exit()}.
}
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
custom_tcb = torch_callback("custom",
  initialize = function(name) {
    self$name = name
  },
  on_begin = function() {
    cat("Hello", self$name, ", we will train for ", self$ctx$total_epochs, "epochs.\n")
  },
  on_end = function() {
    cat("Training is done.")
  }
)

learner = lrn("classif.torch_featureless",
  batch_size = 16,
  epochs = 1,
  callbacks = custom_tcb,
  cb.custom.name = "Marie",
  device = "cpu"
)
task = tsk("iris")
learner$train(task)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Callback: 
\code{\link{TorchCallback}},
\code{\link{as_torch_callback}()},
\code{\link{as_torch_callbacks}()},
\code{\link{callback_set}()},
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr_callback_set}},
\code{\link{mlr_callback_set.checkpoint}},
\code{\link{mlr_callback_set.progress}},
\code{\link{mlr_context_torch}},
\code{\link{t_clbk}()}
}
\concept{Callback}
