% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpICA.R
\name{mlr_pipeops_ica}
\alias{mlr_pipeops_ica}
\alias{PipeOpICA}
\title{Independent Component Analysis}
\format{
\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}
\description{
Extracts statistically independent components from data. Only affects numerical features.
See \link[fastICA:fastICA]{fastICA::fastICA} for details.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpICA$new(id = "ica", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"ica"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpTaskPreproc}}.

The output is the input \code{\link[mlr3:Task]{Task}} with all affected numeric parameters replaced by independent components.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpTaskPreproc}}, as well as the elements of the function \code{\link[fastICA:fastICA]{fastICA::fastICA()}},
with the exception of the \verb{$X} and \verb{$S} slots. These are in particular:
\itemize{
\item \code{K} :: \code{matrix}\cr
Matrix that projects data onto the first \code{n.comp} principal components.
See \code{\link[fastICA:fastICA]{fastICA()}}.
\item \code{W} :: \code{matrix}\cr
Estimated un-mixing matrix. See \code{\link[fastICA:fastICA]{fastICA()}}.
\item \code{A} :: \code{matrix}\cr
Estimated mixing matrix. See \code{\link[fastICA:fastICA]{fastICA()}}.
\item \code{center} :: \code{numeric}\cr
The mean of each numeric feature during training.
}
}

\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreproc}}, as well as the following parameters
based on \code{\link[fastICA:fastICA]{fastICA()}}:
\itemize{
\item \code{n.comp} :: \code{numeric(1)}\cr
Number of components to extract. Default is \code{NULL}, which sets it
to the number of available numeric columns.
\item \code{alg.typ}:: \code{character(1)}\cr
Algorithm type. One of "parallel" (default) or "deflation".
\item \code{fun} :: \code{character(1)}\cr
One of "logcosh" (default) or "exp".
\item \code{alpha} :: \code{numeric(1)}\cr
In range \verb{[1, 2]}, Used for negentropy calculation when \code{fun} is "logcosh".
Default is 1.0.
\item \code{method} :: \code{character(1)}\cr
Internal calculation method. "C" (default) or "R".
See \code{\link[fastICA:fastICA]{fastICA()}}.
\item \code{row.norm} :: \code{logical(1)}\cr
Logical value indicating whether rows should be standardized beforehand.
Default is \code{FALSE}.
\item \code{maxit} :: \code{numeric(1)}\cr
Maximum number of iterations. Default is 200.
\item \code{tol} :: \code{numeric(1)}\cr
Tolerance for convergence, default is \code{1e-4}.
\item \code{verbose} \code{logical(1)}\cr
Logical value indicating the level of output during the run of the algorithm.
Default is \code{FALSE}.
\item \code{w.init}:: \code{matrix}\cr
Initial un-mixing matrix. See \code{\link[fastICA:fastICA]{fastICA()}}.
Default is \code{NULL}.
}
}

\section{Internals}{

Uses the \code{\link[fastICA:fastICA]{fastICA()}} function.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")

task = tsk("iris")
pop = po("ica")

task$data()
pop$train(list(task))[[1]]$data()

pop$state
}
\seealso{
https://mlr3book.mlr-org.com/list-pipeops.html

Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}
}
\concept{PipeOps}
