% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFilter.R
\name{mlr_pipeops_filter}
\alias{mlr_pipeops_filter}
\alias{PipeOpFilter}
\title{PipeOpFilter}
\format{
\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}
\description{
Feature filtering using a \code{\link[mlr3filters:Filter]{mlr3filters::Filter}} object, see the
\CRANpkg{mlr3filters} package.

If a \code{Filter} can only operate on a subset of columns based on column type, then only these features are considered and filtered.
\code{nfeat} and \code{frac} will count for the features of the type that the \code{Filter} can operate on;
this means e.g. that setting \code{nfeat} to 0 will only remove features of the type that the \code{Filter} can work with.
}
\section{Construction}{
\preformatted{PipeOpFilter$new(filter, id = filter$id, param_vals = list())
}
\itemize{
\item \code{filter} :: \code{\link[mlr3filters:Filter]{Filter}}\cr
\code{\link[mlr3filters:Filter]{Filter}} used for feature filtering.
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, defaulting to the \code{id} of the \code{\link[mlr3filters:Filter]{Filter}} being used.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpTaskPreproc}}.

The output is the input \code{\link[mlr3:Task]{Task}} with features removed that were filtered out.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{scores} :: named \code{numeric}\cr
Scores calculated for all features of the training \code{\link[mlr3:Task]{Task}} which are being used
as cutoff for feature filtering. If \code{frac} or \code{nfeat} is given, the underlying \code{\link[mlr3filters:Filter]{Filter}} may choose to not calculate scores for
all features that are given. This only includes features on which the \code{\link[mlr3filters:Filter]{Filter}} can operate; e.g.
if the \code{\link[mlr3filters:Filter]{Filter}} can only operate on numeric features, then scores for factorial features will not be given.
\item \code{features} :: \code{character}\cr
Names of features that are being kept. Features of types that the \code{\link[mlr3filters:Filter]{Filter}} can not operate on are always being kept.
}
}

\section{Parameters}{

The parameters are the parameters inherited from the \code{\link{PipeOpTaskPreproc}}, as well as the parameters of the \code{\link[mlr3filters:Filter]{Filter}}
used by this object. Besides, parameters introduced are:
\itemize{
\item \code{filter.nfeat} :: \code{numeric(1)} \cr
Number of features to select.
Mutually exclusive with \code{frac} and \code{cutoff}.
\item \code{filter.frac} :: \code{numeric(1)} \cr
Fraction of features to keep.
Mutually exclusive with \code{nfeat} and \code{cutoff}.
\item \code{filter.cutoff} :: \code{numeric(1)} \cr
Minimum value of filter heuristic for which to keep features.
Mutually exclusive with \code{nfeat} and \code{frac}.
}

Note that at least one of \code{filter.nfeat}, \code{filter.frac}, or \code{filter.cutoff} must be given.
}

\section{Internals}{

This does \emph{not} use the \verb{$.select_cols} feature of \code{\link{PipeOpTaskPreproc}} to select only features compatible with the \code{\link[mlr3filters:Filter]{Filter}};
instead the whole \code{\link[mlr3:Task]{Task}} is used by \code{private$.get_state()} and subset internally.
}

\section{Fields}{

Fields inherited from \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{filter} :: \code{\link[mlr3filters:Filter]{Filter}}\cr
\code{\link[mlr3filters:Filter]{Filter}} that is being used for feature filtering. Do \emph{not} use this slot to get to the feature filtering scores
after training; instead, use \verb{$state$scores}. Read-only.
}
}

\section{Methods}{

Methods inherited from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")
library("mlr3filters")

# setup PipeOpFilter to keep the 5 most important
# features of the spam task w.r.t. their AUC
task = tsk("spam")
filter = flt("auc")
po = po("filter", filter = filter)
po$param_set
po$param_set$values$filter.nfeat = 5

# filter the task
filtered_task = po$train(list(task))[[1]]

# filtered task + extracted AUC scores
filtered_task$feature_names
head(po$state$scores, 10)

# feature selection embedded in a 3-fold cross validation
# keep 30\% of features based on their AUC score
task = tsk("spam")
gr = po("filter", filter = flt("auc"), filter.frac = 0.5) \%>>\%
  po("learner", lrn("classif.rpart"))
learner = GraphLearner$new(gr)
rr = resample(task, learner, rsmp("holdout"), store_models = TRUE)
rr$learners[[1]]$model$auc$scores
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}
}
\concept{PipeOps}
