% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpBranch.R
\name{branch}
\alias{branch}
\title{Branch Between Alternative Paths}
\usage{
branch(..., .graphs = NULL, .prefix_branchops = "",
  .prefix_paths = FALSE)
}
\arguments{
\item{...}{Multiple graphs, possibly named. They all must have exactly
one output. If any of the arguments are named, then all must have
unique names.}

\item{.graphs}{(\code{[list of Graph]}):
Named list of Graphs, additionally to the graphs given in \code{...}.}

\item{.prefix_branchops}{(\code{[character(1)]}):
Optional id prefix to prepend to \code{\link{PipeOpBranch}} and \code{\link{PipeOpUnbranch}} id. Their
resulting IDs will be \code{"[.prefix_branchops]branch"} and \code{"[.prefix_branchops]unbranch"}.
Default is \code{""}.}

\item{.prefix_paths}{(\code{[logical(1) | character(1)]}):
Whether to add prefixes to graph IDs when performing gunion. Can be helpful to
avoid ID clashes in resulting graph. Default \code{FALSE}. If this is \code{TRUE}, the prefixes
are taken from the names of the input arguments if present or \code{"poX"} where X counts up. If this is
a \code{character(1)}, it is a prefix that is added to the \code{PipeOp} IDs \emph{additionally}
to the input argument list.}
}
\description{
Create a multiplexed graph.
}
\examples{
library("mlr3")

po_pca = po("pca")
po_nop = po("nop")

branches = branch(pca = po_pca, nothing = po_nop)
# gives the same as
branches = c("pca", "nothing")
po("branch", branches) \%>>\%
  gunion(list(po_pca, po_nop)) \%>>\%
  po("unbranch", branches)

branch(pca = po_pca, nothing = po_nop,
  .prefix_branchops = "br_", .prefix_paths = "xy_")
# gives the same as
po("branch", branches, id = "br_branch") \%>>\%
  gunion(list(xy_pca = po_pca, xy_nothing = po_nop)) \%>>\%
  po("unbranch", branches, id = "br_unbranch")
}
