% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_filters.R
\docType{data}
\name{mlr_filters}
\alias{mlr_filters}
\title{Dictionary of Filters}
\format{
\link[R6:R6Class]{R6::R6Class} object
}
\usage{
mlr_filters
}
\description{
A simple \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \link{Filter}.
Each Filter has an associated help page, see \code{mlr_filters_[id]}.

This dictionary can get populated with additional filters by add-on packages.

For a more convenient way to retrieve and construct filters, see \code{\link[=flt]{flt()}}.
}
\section{Usage}{


See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\examples{
mlr_filters$keys()
as.data.table(mlr_filters)
mlr_filters$get("mim")
flt("anova")
}
\seealso{
Other Filter: 
\code{\link{Filter}},
\code{\link{mlr_filters_anova}},
\code{\link{mlr_filters_auc}},
\code{\link{mlr_filters_boruta}},
\code{\link{mlr_filters_carscore}},
\code{\link{mlr_filters_carsurvscore}},
\code{\link{mlr_filters_cmim}},
\code{\link{mlr_filters_correlation}},
\code{\link{mlr_filters_disr}},
\code{\link{mlr_filters_find_correlation}},
\code{\link{mlr_filters_importance}},
\code{\link{mlr_filters_information_gain}},
\code{\link{mlr_filters_jmi}},
\code{\link{mlr_filters_jmim}},
\code{\link{mlr_filters_kruskal_test}},
\code{\link{mlr_filters_mim}},
\code{\link{mlr_filters_mrmr}},
\code{\link{mlr_filters_njmim}},
\code{\link{mlr_filters_performance}},
\code{\link{mlr_filters_permutation}},
\code{\link{mlr_filters_relief}},
\code{\link{mlr_filters_selected_features}},
\code{\link{mlr_filters_univariate_cox}},
\code{\link{mlr_filters_variance}}
}
\concept{Dictionary}
\concept{Filter}
\keyword{datasets}
