% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterAUC.R
\name{FilterAUC}
\alias{FilterAUC}
\alias{mlr_filters_auc}
\title{AUC Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Area under the (ROC) Curve filter, analogously to \code{\link[mlr3measures:auc]{mlr3measures::auc()}} from \CRANpkg{mlr3measures}.
Missing values of the features are removed before calculating the AUC.
If the AUC is undefined for the input, it is set to 0.5 (random classifier).
The absolute value of the difference between the AUC and 0.5 is used as final filter value.
}
\section{Construction}{
\preformatted{FilterAUC$new()
mlr_filters$get("auc")
flt("auc")
}
}

\examples{
task = mlr3::tsk("pima")
filter = flt("auc")
filter$calculate(task)
head(as.data.table(filter), 3)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: 
\code{\link{FilterAnova}},
\code{\link{FilterCMIM}},
\code{\link{FilterCarScore}},
\code{\link{FilterCorrelation}},
\code{\link{FilterDISR}},
\code{\link{FilterImportance}},
\code{\link{FilterInformationGain}},
\code{\link{FilterJMIM}},
\code{\link{FilterJMI}},
\code{\link{FilterKruskalTest}},
\code{\link{FilterMIM}},
\code{\link{FilterMRMR}},
\code{\link{FilterNJMIM}},
\code{\link{FilterPerformance}},
\code{\link{FilterVariance}},
\code{\link{Filter}},
\code{\link{mlr_filters}}
}
\concept{Filter}
