% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterMRMR.R
\docType{data}
\name{FilterMRMR}
\alias{FilterMRMR}
\alias{mlr_filters_mrmr}
\title{Minimum redundancy maximal relevancy filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Minimum redundancy maximal relevancy filter calling
\code{\link[praznik:MRMR]{praznik::MRMR()}} in package \CRANpkg{praznik}.

This filter supports partial scoring (see \link{Filter}).
}
\section{Construction}{
\preformatted{FilterMRMR$new()
mlr_filters$get("mrmr")
flt("mrmr")
}
}

\examples{
task = mlr3::tsk("iris")
filter = flt("mrmr")
filter$calculate(task, nfeat = 2)
as.data.table(filter)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: \code{\link{FilterAUC}},
  \code{\link{FilterAnova}}, \code{\link{FilterCMIM}},
  \code{\link{FilterCarScore}},
  \code{\link{FilterCorrelation}},
  \code{\link{FilterDISR}}, \code{\link{FilterImportance}},
  \code{\link{FilterInformationGain}},
  \code{\link{FilterJMIM}}, \code{\link{FilterJMI}},
  \code{\link{FilterKruskalTest}}, \code{\link{FilterMIM}},
  \code{\link{FilterNJMIM}},
  \code{\link{FilterPerformance}},
  \code{\link{FilterVariance}}, \code{\link{Filter}},
  \code{\link{mlr_filters}}
}
\concept{Filter}
\keyword{datasets}
