% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterDISR.R
\docType{data}
\name{FilterDISR}
\alias{FilterDISR}
\alias{mlr_filters_disr}
\title{Double Input Symmetrical Relevance Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Double input symmetrical relevance filter calling
\code{\link[praznik:DISR]{praznik::DISR()}} from package \CRANpkg{praznik}.

This filter supports partial scoring (see \link{Filter}).
}
\section{Construction}{
\preformatted{FilterDISR$new()
mlr_filters$get("disc")
flt("disc")
}
}

\examples{
task = mlr3::tsk("iris")
filter = flt("disr")
filter$calculate(task, nfeat = 2)
as.data.table(filter)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: \code{\link{FilterAUC}},
  \code{\link{FilterAnova}}, \code{\link{FilterCMIM}},
  \code{\link{FilterCarScore}},
  \code{\link{FilterCorrelation}},
  \code{\link{FilterImportance}},
  \code{\link{FilterInformationGain}},
  \code{\link{FilterJMIM}}, \code{\link{FilterJMI}},
  \code{\link{FilterKruskalTest}}, \code{\link{FilterMIM}},
  \code{\link{FilterMRMR}}, \code{\link{FilterNJMIM}},
  \code{\link{FilterPerformance}},
  \code{\link{FilterVariance}}, \code{\link{Filter}},
  \code{\link{mlr_filters}}
}
\concept{Filter}
\keyword{datasets}
