% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendDplyr.R
\docType{data}
\name{DataBackendDplyr}
\alias{DataBackendDplyr}
\title{DataBackend for dplyr/dbplyr}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3:DataBackend]{mlr3::DataBackend}.}
\description{
A \link[mlr3:DataBackend]{mlr3::DataBackend} using \code{\link[dplyr:tbl]{dplyr::tbl()}} from packages \CRANpkg{dplyr}/\CRANpkg{dbplyr}.
This includes \code{\link[tibble:tibble]{tibbles}}.
Allows to let a \link[mlr3:Task]{mlr3::Task} interface an out-of-memory data base.
}
\section{Construction}{
\preformatted{DataBackendDplyr$new(data, primary_key = NULL)
}
\itemize{
\item \code{data} :: \code{\link[dplyr:tbl]{dplyr::tbl()}}\cr
The data object.
\item \code{primary_key} :: \code{character(1)}\cr
Name of the primary key column.
}

Alternatively, use \code{\link[mlr3:as_data_backend]{mlr3::as_data_backend()}} on a \code{\link[dplyr:tbl]{dplyr::tbl()}} which will
construct a \link{DataBackend} for you.
}

\section{Fields}{


\itemize{
\item \code{nrow} :: \code{integer(1)}\cr
Number of rows (observations).
\item \code{ncol} :: \code{integer(1)}\cr
Number of columns (variables), including the primary key column.
\item \code{colnames} :: \code{character()}\cr
Returns vector of all column names, including the primary key column.
\item \code{rownames} :: (\code{integer()} | \code{character()})\cr
Returns vector of all distinct row identifiers, i.e. the primary key column.
\item \code{hash} :: \code{character(1)}\cr
Returns a unique hash for this backend. This hash is cached.
\item \code{data_formats} :: \code{character()}\cr
Vector of supported data formats.
A specific format can be chosen in the \code{$data()} method.
}

}

\section{Methods}{


\itemize{
\item \code{data(rows = NULL, cols = NULL, format = "data.table")}\cr
(\code{integer()} | \code{character()}, \code{character()}) -> \code{any}\cr
Returns a slice of the data in the specified format.
Currently, the only supported formats are \code{"data.table"} and \code{"Matrix"}.
The rows must be addressed as vector of primary key values, columns must be referred to via column names.
Queries for rows with no matching row id and queries for columns with no matching column name are silently ignored.
Rows are guaranteed to be returned in the same order as \code{rows}, columns may be returned in an arbitrary order.
Duplicated row ids result in duplicated rows, duplicated column names lead to an exception.
\item \code{distinct(rows, cols, na_rm = TRUE)}\cr
(\code{integer()} | \code{character()}, \code{character()}, \code{logical(1)}) -> named \code{list()}\cr
Returns a named list of vectors of distinct values for each column specified.
If \code{na_rm} is \code{TRUE}, missing values are removed from the returned vectors of distinct values.
Non-existing rows and columns are silently ignored.

If \code{rows} is \code{NULL}, all possible distinct values will be returned, even if the value is not present in the data.
This affects factor-like variables with empty levels, if supported by the backend.
\item \code{head(n = 6)}\cr
\code{integer(1)} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns the first up-to \code{n} rows of the data as \code{\link[data.table:data.table]{data.table::data.table()}}.
\item \code{missings(rows, cols)}\cr
(\code{integer()} | \code{character()}, \code{character()}) -> named \code{integer()}\cr
Returns the number of missing values per column in the specified slice of data.
Non-existing rows and columns are silently ignored.
}

}

\examples{
# Backend using a in-memory tibble
data = tibble::as_tibble(iris)
data$Sepal.Length[1:30] = NA
data$row_id = 1:150
b = DataBackendDplyr$new(data, primary_key = "row_id")

# Object supports all accessors of DataBackend
print(b)
b$nrow
b$ncol
b$colnames
b$data(rows = 100:101, cols = "Species")
b$distinct(b$rownames, "Species")

# Classification task using this backend
task = mlr3::TaskClassif$new(id = "iris_tibble", backend = b, target = "Species")
print(task)
task$head()

# Create a temporary SQLite data base
con = DBI::dbConnect(RSQLite::SQLite(), ":memory:")
dplyr::copy_to(con, data)
tbl = dplyr::tbl(con, "data")

# Define a backend on a subset of the data base
tbl = dplyr::select_at(tbl, setdiff(colnames(tbl), "Sepal.Width")) # do not use column "Sepal.Width"
tbl = dplyr::filter(tbl, row_id \%in\% 1:120) # Use only first 120 rows
b = DataBackendDplyr$new(tbl, primary_key = "row_id")
print(b)

# Query disinct values
b$distinct(b$rownames, "Species")

# Query number of missing values
b$missings(b$rownames, b$colnames)

# Note that SQLite does not support factors, column Species has been converted to character
lapply(b$head(), class)

# Cleanup
rm(tbl)
DBI::dbDisconnect(con)
}
\keyword{datasets}
