% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClustCMeans.R
\name{mlr_learners_clust.cmeans}
\alias{mlr_learners_clust.cmeans}
\alias{LearnerClustCMeans}
\title{Fuzzy C-Means Clustering Learner}
\description{
A \link{LearnerClust} for fuzzy clustering implemented in \code{\link[e1071:cmeans]{e1071::cmeans()}}.
\code{\link[e1071:cmeans]{e1071::cmeans()}} doesn't have a default value for the number of clusters.
Therefore, the \code{centers} parameter here is set to 2 by default.
The predict method uses \code{\link[clue:cl_predict]{clue::cl_predict()}} to compute the
cluster memberships for new data.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("clust.cmeans")
lrn("clust.cmeans")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{clust}
\item Predict Types: \dQuote{partition}, \dQuote{prob}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3cluster}, \CRANpkg{e1071}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   centers \tab untyped \tab 2 \tab  \tab - \cr
   iter.max \tab integer \tab 100 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   verbose \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   dist \tab character \tab euclidean \tab euclidean, manhattan \tab - \cr
   method \tab character \tab cmeans \tab cmeans, ufcl \tab - \cr
   m \tab numeric \tab 2 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   rate.par \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   weights \tab untyped \tab 1 \tab  \tab - \cr
   control \tab untyped \tab - \tab  \tab - \cr
}
}

\examples{
if (requireNamespace("e1071")) {
  learner = mlr3::lrn("clust.cmeans")
  print(learner)

  # available parameters:
  learner$param_set$ids()
}
}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3cluster:LearnerClust]{mlr3cluster::LearnerClust}} -> \code{LearnerClustCMeans}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClustCMeans-new}{\code{LearnerClustCMeans$new()}}
\item \href{#method-LearnerClustCMeans-clone}{\code{LearnerClustCMeans$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3cluster" data-topic="LearnerClust" data-id="reset"><a href='../../mlr3cluster/html/LearnerClust.html#method-LearnerClust-reset'><code>mlr3cluster::LearnerClust$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustCMeans-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustCMeans-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustCMeans$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustCMeans-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustCMeans-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustCMeans$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
