% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSimple.R
\name{mlr_measures_sim.phi}
\alias{mlr_measures_sim.phi}
\title{Phi Coefficient Similarity}
\description{
Measure to compare two or more sets w.r.t. their similarity.
}
\details{
The Phi Coefficient is defined as the Pearson correlation between the binary
representation of two sets \eqn{A} and \eqn{B}.
The binary representation for \eqn{A} is a logical vector of
length \eqn{p} with the i-th element being 1 if the corresponding
element is in \eqn{A}, and 0 otherwise.

If more than two sets are provided, the mean of all pairwise scores
is calculated.

This measure is undefined if one set contains none or all possible elements.
}
\note{
This measure requires learners with property \code{"selected_features"}.
The extracted feature sets are passed to \code{\link[mlr3measures:phi]{mlr3measures::phi()}} from
package \CRANpkg{mlr3measures}.

If the measure is undefined for the input, \code{NaN} is returned.
This can be customized by setting the field \code{na_value}.
}
\section{Dictionary}{

This \link{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_measures} or with the associated sugar function \code{\link[=msr]{msr()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_measures$get("sim.phi")
msr("sim.phi")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{


\itemize{
\item Type: \code{"similarity"}
\item Range: \eqn{[-1, 1]}{[-1, 1]}
\item Minimize: \code{FALSE}
}

}

\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}

\code{as.data.table(mlr_measures)} for a complete table of all (also dynamically created) \link{Measure} implementations.

Other similarity measures: 
\code{\link{mlr_measures_sim.jaccard}}
}
\concept{similarity measures}
