% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkResult.R
\docType{data}
\name{BenchmarkResult}
\alias{BenchmarkResult}
\title{Container for Results of \code{benchmark()}}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the result container object returned by \code{\link[=benchmark]{benchmark()}}.

Note that all stored objects are accessed by reference.
Do not modify any object without cloning it first.
}
\section{Construction}{
\preformatted{bmr = BenchmarkResult$new(data = data.table())
}
\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table with data for one resampling iteration per row:
\link{Task}, \link{Learner}, \link{Resampling}, iteration (\code{integer(1)}), \link{Prediction}, and the hash (\code{character(1)})
of the corresponding \link{ResampleResult}.
}
}

\section{Fields}{

\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Internal data storage.
We discourage users to directly work with this field.
\item \code{task_type} :: \code{character(1)}\cr
Task type of objects in the \code{BenchmarkResult}.
All stored objects (\link{Task}, \link{Learner}, \link{Prediction}) in a single \code{BenchmarkResult} are required to have the same task type, e.g., \code{"classif"} or \code{"regr"}.
\item \code{tasks} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used tasks with three columns:
\code{"task_hash"} (\code{character(1)}), \code{"task_id"} (\code{character(1)}) and \code{"task"} (\link{Task}).
\item \code{learners} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used learners with three columns:
\code{"learner_hash"} (\code{character(1)}), \code{"learner_id"} (\code{character(1)}) and \code{"learner"} (\link{Learner}).
\item \code{resamplings} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Table of used resamplings with three columns:
\code{"resampling_hash"} (\code{character(1)}), \code{"resampling_id"} (\code{character(1)}) and \code{"resampling"} (\link{Resampling}).
\item \code{n_resample_results} :: \code{integer(1)}\cr
Returns the number of stored \link{ResampleResult}s.
\item \code{hashes} :: \code{character()}\cr
Vector of hashes of all included \link{ResampleResult}s.
}
}

\section{Methods}{

\itemize{
\item \code{aggregate(measures = NULL, ids = TRUE, params = FALSE, warnings = FALSE, errors = FALSE)}\cr
(list of \link{Measure}, \code{logical(1)}, \code{logical(1)}, \code{logical(1)}, \code{logical(1)}) -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a result table where resampling iterations are aggregated together into \link{ResampleResult}s.
A column with the aggregated performance is added for each \link{Measure}, named with the id of the respective measure.

Additional arguments control the number of additional columns:
\itemize{
\item \code{ids} :: \code{logical(1)}\cr
Adds object ids (\code{"task_id"}, \code{"learner_id"}, \code{"resampling_id"}) as extra character columns.
\item \code{params} :: \code{logical(1)}\cr
Adds the hyperparameter values as extra list column \code{"params"}.
You can unnest them with \code{\link[mlr3misc:unnest]{mlr3misc::unnest()}}.
\item \code{warnings} :: \code{logical(1)}\cr
Adds the number of resampling iterations with at least one warning as extra integer column \code{"warnings"}.
\item \code{errors} :: \code{logical(1)}\cr
Adds the number of resampling iterations with errors as extra integer column \code{"errors"}.
}
\item \code{performance(measures = NULL, ids = TRUE)}\cr
(list of \link{Measure}, \code{logical(1)}) -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a table with one row for each resampling iteration, including all involved objects:
\link{Task}, \link{Learner}, \link{Resampling}, iteration number (\code{integer(1)}), and \link{Prediction}.
If \code{ids} is set to \code{TRUE}, character column of extracted ids are added to the table for convenient filtering: \code{"task_id"}, \code{"learner_id"}, and \code{"resampling_id"}.
Additionally calculates the provided performance measures and binds the performance as extra columns.
These columns are named using the id of the respective \link{Measure}.
\item \code{resample_result(i)}\cr
(\code{integer(1)} -> \link{ResampleResult})\cr
Retrieve the i-th \link{ResampleResult}.
\item \code{combine(bmr)}\cr
(\link{BenchmarkResult} | \code{NULL}) -> \code{self}\cr
Fuses a second \link{BenchmarkResult} into itself, mutating the \link{BenchmarkResult} in-place.
If \code{bmr} is \code{NULL}, simply returns \code{self}.

In case of duplicated \link{ResampleResult}s, an exception is raised.
Two \link{ResampleResult}s are identical iff the hashes of the respective \link{Task}, \link{Learner} and \link{Resampling} are identical.
I.e., they must operate on the exactly same data, with the same learner with the same hyperparameters and
the same splits into training and test sets.
}
}

\section{S3 Methods}{

\itemize{
\item \code{as.data.table(bmr)}\cr
\link{BenchmarkResult} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a copy of the internal data.
}
}

\examples{
set.seed(123)
learners = list(
  lrn("classif.featureless", predict_type = "prob"),
  lrn("classif.rpart", predict_type = "prob")
)

design = benchmark_grid(
  tasks = list(tsk("sonar"), tsk("spam")),
  learners = learners,
  resamplings = rsmp("cv", folds = 3)
)
print(design)

bmr = benchmark(design)
print(bmr)

bmr$tasks
bmr$learners

# first 5 individual resamplings
head(as.data.table(bmr, measures = c("classif.acc", "classif.auc")), 5)

# aggregate results
bmr$aggregate()

# aggregate results with hyperparameters as separate columns
mlr3misc::unnest(bmr$aggregate(params = TRUE), "params")

# extract resample result for classif.rpart
rr = bmr$aggregate()[learner_id == "classif.rpart", resample_result][[1]]
print(rr)

# access the confusion matrix of the first resampling iteration
rr$data$prediction[[1]]$confusion
}
\keyword{datasets}
