% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBMRRanksAsBarChart.R
\name{plotBMRRanksAsBarChart}
\alias{plotBMRRanksAsBarChart}
\title{Create a bar-chart for ranks in a BenchmarkResult.}
\usage{
plotBMRRanksAsBarChart(bmr, measure = NULL, ties.method = "average",
  aggregation = "default", pos = "stack", order.lrns = NULL,
  order.tsks = NULL)
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{ties.method}{[\code{character(1)}]\cr
See \code{\link{rank}} for details.}

\item{aggregation}{[\code{character(1)}] \cr
\dQuote{mean} or \dQuote{default}. See \code{\link{getBMRAggrPerformances}}
for details on \dQuote{default}.}

\item{pos}{[\code{character(1)}]
Optionally set how the bars are positioned in \code{\link{ggplot2}}.
Ranks are plotted on the x-axis.
\dQuote{tile} plots a heatmap with \code{task} as the y-axis.
Allows identification of the performance in a special task.
\dQuote{stack} plots a stacked barplot. r
Allows for comparison of learners within and and accross ranks.
\dQuote{dodge} plots a barplot with bars next to each other instead
of stacked bars.}

\item{order.lrns}{[\code{character(n.learners)}]\cr 
Character vector with \code{learner.ids} in new order.}

\item{order.tsks}{[\code{character(n.tasks)}] \cr 
Character vector with \code{task.ids} in new order.}
}
\value{
ggplot2 plot object.
}
\description{
Plots a barchart from the ranks of algorithms. Alternatively
tiles can be plotted for every rank-task combination, see \code{pos}
for details. The x-axis accross all plots is the ranks of a learner.id.
Areas are always coloured corresponding to the learner.
}
\examples{
# see benchmark
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCritDifferences}}

Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

