% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relativeOverfitting.R
\name{estimateRelativeOverfitting}
\alias{estimateRelativeOverfitting}
\alias{estimateRelativeOverfitting.ResampleDesc}
\title{Estimate relative overfitting.}
\usage{
estimateRelativeOverfitting(rdesc, measures, task, learner)

\method{estimateRelativeOverfitting}{ResampleDesc}(rdesc, measures, task,
  learner)
}
\arguments{
\item{rdesc}{[\code{\link{ResampleDesc}}\cr
Resampling strategy.}

\item{measures}{[\code{\link{Measure}} | list of \code{\link{Measure}}]\cr
Performance measure(s) to evaluate.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}
}
\value{
[\code{data.frame}]. Relative overfitting estimate(s), named by measure(s), for each resampling iteration.
}
\description{
Estimates the relative overfitting of a model as the ratio of the difference in test and train performance to the difference of test performance in the no-information case and train performance.
In the no-information case the features carry no information with respect to the prediction. This is simulated by permuting features and predictions.
}
\details{
Currently only support for classification and regression tasks is implemented.
}
\examples{
task = makeClassifTask(data = iris, target = "Species")
rdesc = makeResampleDesc("CV", iters = 2)
estimateRelativeOverfitting(rdesc, acc, task, makeLearner("classif.knn"))
estimateRelativeOverfitting(rdesc, acc, task, makeLearner("classif.lda"))
}
\references{
Bradley Efron and Robert Tibshirani; Improvements on Cross-Validation: The .632+ Bootstrap Method, Journal of the American Statistical Association, Vol. 92, No. 438. (Jun., 1997), pp. 548-560.
}
\seealso{
Other performance: \code{\link{makeCostMeasure}},
  \code{\link{makeCustomResampledMeasure}},
  \code{\link{makeMeasure}}, \code{\link{measures}},
  \code{\link{performance}}
}

