% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measure_custom_resampled.R
\name{makeCustomResampledMeasure}
\alias{makeCustomResampledMeasure}
\title{Construct your own resampled performance measure.}
\usage{
makeCustomResampledMeasure(measure.id, aggregation.id, minimize = TRUE,
  properties = character(0L), fun, extra.args = list(), best = NULL,
  worst = NULL, measure.name = measure.id,
  aggregation.name = aggregation.id, note = "")
}
\arguments{
\item{measure.id}{(`character(1)`)\cr
Short name of measure.}

\item{aggregation.id}{(`character(1)`)\cr
Short name of aggregation.}

\item{minimize}{(`logical(1)`)\cr
Should the measure be minimized?
Default is `TRUE`.}

\item{properties}{([character])\cr
Set of measure properties. For a list of values see [Measure].
Default is `character(0)`.}

\item{fun}{(`function(task, group, pred, extra.args)`)\cr
Calculates performance value from [ResamplePrediction] object.
For rare cases you can also use the task, the grouping or the extra arguments `extra.args`.
\describe{
  \item{`task` ([Task])}{
    The task.}
  \item{`group` ([factor])}{
    Grouping of resampling iterations. This encodes whether specific iterations
    'belong together' (e.g. repeated CV).}
  \item{`pred` ([Prediction])}{
    Prediction object.}
  \item{`extra.args` ([list])}{
    See below.}
}}

\item{extra.args}{([list])\cr
List of extra arguments which will always be passed to `fun`.
Default is empty list.}

\item{best}{(`numeric(1)`)\cr
Best obtainable value for measure.
Default is -`Inf` or `Inf`, depending on `minimize`.}

\item{worst}{(`numeric(1)`)\cr
Worst obtainable value for measure.
Default is `Inf` or -`Inf`, depending on `minimize`.}

\item{measure.name}{(`character(1)`)\cr
Long name of measure.
Default is `measure.id`.}

\item{aggregation.name}{(`character(1)`)\cr
Long name of the aggregation.
Default is `aggregation.id`.}

\item{note}{([character]) \cr
Description and additional notes for the measure. Default is \dQuote{}.}
}
\value{
\link{Measure}.
}
\description{
Construct your own performance measure, used after resampling.
Note that individual training / test set performance values will be set to `NA`, you
only calculate an aggregated value. If you can define a function that makes sense
for every single training / test set, implement your own [Measure].
}
\seealso{
Other performance: \code{\link{ConfusionMatrix}},
  \code{\link{calculateConfusionMatrix}},
  \code{\link{calculateROCMeasures}},
  \code{\link{estimateRelativeOverfitting}},
  \code{\link{makeCostMeasure}}, \code{\link{makeMeasure}},
  \code{\link{measures}}, \code{\link{performance}},
  \code{\link{setAggregation}},
  \code{\link{setMeasurePars}}
}
