% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLearner.R
\name{makeLearner}
\alias{makeLearner}
\alias{Learner}
\title{Create learner object.}
\usage{
makeLearner(cl, id = cl, predict.type = "response",
  predict.threshold = NULL, fix.factors.prediction = FALSE, ...,
  par.vals = list(), config = list())
}
\arguments{
\item{cl}{[\code{character(1)}]\cr
Class of learner. By convention, all classification learners
start with \dQuote{classif.}, all regression learners with
\dQuote{regr.}, all survival learners start with \dQuote{surv.},
all clustering learners with \dQuote{cluster.}, and all multilabel
classification learners start with \dQuote{multilabel.}.
A list of all integrated learners is available on the
\code{\link{learners}} help page.}

\item{id}{[\code{character(1)}]\cr
Id string for object. Used to display object.
Default is \code{cl}.}

\item{predict.type}{[\code{character(1)}]\cr
Classification: \dQuote{response} (= labels) or \dQuote{prob} (= probabilities and labels by selecting the ones with maximal probability).
Regression: \dQuote{response} (= mean response) or \dQuote{se} (= standard errors and mean response).
Survival: \dQuote{response} (= some sort of orderable risk) or \dQuote{prob} (= time dependent probabilities).
Clustering: \dQuote{response} (= cluster IDS) or \dQuote{prob} (= fuzzy cluster membership probabilities),
Multilabel: \dQuote{response} (= logical matrix indicating the predicted class labels) or \dQuote{prob} (= probabilities and corresponding logical matrix indicating class labels).
Default is \dQuote{response}.}

\item{predict.threshold}{[\code{numeric}]\cr
Threshold to produce class labels. Has to be a named vector, where names correspond to class labels.
Only for binary classification it can be a single numerical threshold for the positive class.
See \code{\link{setThreshold}} for details on how it is applied.
Default is \code{NULL} which means 0.5 / an equal threshold for each class.}

\item{fix.factors.prediction}{[\code{logical(1)}]\cr
In some cases, problems occur in underlying learners for factor features during prediction.
If the new features have LESS factor levels than during training (a strict subset),
the learner might produce an  error like
\dQuote{type of predictors in new data do not match that of the training data}.
In this case one can repair this problem by setting this option to \code{TRUE}.
We will simply add the missing factor levels missing from the test feature
(but present in training) to that feature.
Default is \code{FALSE}.}

\item{...}{[any]\cr
Optional named (hyper)parameters.
Alternatively these can be given using the \code{par.vals} argument.}

\item{par.vals}{[\code{list}]\cr
Optional list of named (hyper)parameters. The arguments in
\code{...} take precedence over values in this list. We strongly
encourage you to use one or the other to pass (hyper)parameters
to the learner but not both.}

\item{config}{[\code{named list}]\cr
Named list of config option to overwrite global settings set via \code{\link{configureMlr}}
for this specific learner.}
}
\value{
[\code{\link{Learner}}].
}
\description{
For a classification learner the \code{predict.type} can be set
to \dQuote{prob} to predict probabilities and the maximum
value selects the label. The threshold used to assign the label can later be changed using the
\code{\link{setThreshold}} function.

To see all possible properties of a learner, go to: \code{\link{LearnerProperties}}.
}
\examples{
makeLearner("classif.rpart")
makeLearner("classif.lda", predict.type = "prob")
lrn = makeLearner("classif.lda", method = "t", nu = 10)
print(lrn$par.vals)
}
\seealso{
Other learner: \code{\link{LearnerProperties}},
  \code{\link{getClassWeightParam}},
  \code{\link{getHyperPars}}, \code{\link{getLearnerId}},
  \code{\link{getLearnerPackages}},
  \code{\link{getLearnerParVals}},
  \code{\link{getLearnerParamSet}},
  \code{\link{getLearnerPredictType}},
  \code{\link{getLearnerShortName}},
  \code{\link{getLearnerType}}, \code{\link{getParamSet}},
  \code{\link{makeLearners}},
  \code{\link{removeHyperPars}},
  \code{\link{setHyperPars}}, \code{\link{setId}},
  \code{\link{setLearnerId}},
  \code{\link{setPredictThreshold}},
  \code{\link{setPredictType}}
}
