% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getFilterValues}
\alias{getFilterValues}
\title{Calculates feature filter values.}
\usage{
getFilterValues(task, method = "random.forest.importance", ...)
}
\arguments{
\item{task}{[\code{\link{SupervisedTask}}]\cr
The task.}

\item{method}{[\code{character(1)}]\cr
Filter method, see above.
Default is \dQuote{random.forest.importance}.}

\item{...}{[any]\cr
Passed down to selected method.}
}
\value{
[\code{\link{FilterValues}}].
}
\description{
Calculates numerical filter values for all features.
Look at package \code{\link[FSelector]{FSelector}} for details on the filter algorithms.

Currently only supports classification (C) and regression (R). Allowed feature types are abbreviated
in table as numerics (N) and factors (F).

Available \code{method}s are:
\tabular{llll}{
  Method                     \tab Tasks \tab Feats \tab Description \cr
  linear.correlation         \tab R     \tab N     \tab
    Pearson's correlation between feature and target \cr
  rank.correlation           \tab R     \tab N     \tab
    Spearman's correlation between feature and target \cr
  information.gain           \tab C,R   \tab N,F   \tab
    Entropy-based information gain between feature and target \cr
  gain.ratio                 \tab C,R   \tab N,F   \tab
    Entropy-based gain ratio between feature and target \cr
  symmetrical.uncertainty    \tab C,R   \tab N,F   \tab
    Entropy-based symmetrical uncertainty between feature and target \cr
  chi.squared                \tab C,R   \tab N,F   \tab
    Chi-squared statistic of independence between feature and target \cr
  random.forest.importance   \tab C,R   \tab N,F   \tab
    See \code{\link[randomForest]{importance}} \cr
  relief                     \tab C,R   \tab N,F   \tab
    RELIEF algorithm \cr
  oneR                       \tab C,R   \tab N,F   \tab
    \code{\link[RWeka]{OneR}} assocation rule \cr
  mRMR.classic               \tab R     \tab N     \tab
    MRMR algorithm, see \code{\link[mRMRe]{mRMR.classic}} from \code{mRMRe} package \cr
}
}
\seealso{
Other filter: \code{\link{FilterResult}},
  \code{\link{getFilterResult}};
  \code{\link{FilterValues}}; \code{\link{filterFeatures}};
  \code{\link{getFilteredFeatures}};
  \code{\link{listFilterMethods}};
  \code{\link{makeFilterWrapper}}
}

