% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.design.R
\name{find.design}
\alias{find.design}
\title{Find optimal study designs}
\usage{
find.design(
  simfun,
  boundaries,
  power = NULL,
  evaluations = 4000,
  ci = NULL,
  ci_perc = 0.95,
  time = NULL,
  costfun = NULL,
  cost = NULL,
  surrogate = NULL,
  n.startsets = 4,
  init.perc = 0.2,
  setsize = 100,
  continue = NULL,
  dat = NULL,
  silent = FALSE,
  autosave_dir = NULL,
  control = list()
)
}
\arguments{
\item{simfun}{function to generate hypothesis test results with. Takes design parameters as input and outputs a logical (result of the hypothesis test). The function can take the designs through one argument as a vector or through multiple arguments. For example, function(x) where x is later used with x=c(n,k) for two design parameters n and k is valid. Also valid is a definition using function(n,k).}

\item{boundaries}{list containing lower and upper bounds of the design space. The list should consist of named vectors, each containing the upper and lower bound for the respective design parameter dimensions. For one design parameter dimension, can also be a vector containing the upper and lower bounds.}

\item{power}{numeric; desired statistical power}

\item{evaluations}{integer; number of dgf evaluations to be performed before termination}

\item{ci}{numeric; desired width of the confidence interval at the predicted value on termination.}

\item{ci_perc}{numeric; specifying the desired confidence interval, e.g. 95\% or 99\%.}

\item{time}{integer; seconds until termination}

\item{costfun}{function that takes a vector of design parameters as input and outputs a cost, e.g. monetary costs. Necessary for simfuns with multiple input dimensions.}

\item{cost}{numeric; cost threshold. Design parameter set with highest power is searched among sets that fulfill this cost threshold.}

\item{surrogate}{character; which surrogate model should be used. The default is 'logreg' for one design parameter and 'gpr' for multiple design parameters. The current options are: 'gpr', 'svr', 'logreg', 'reg' for one-dimensional designs and 'gpr' and 'svr' for multi-dimensional designs.}

\item{n.startsets}{integer; number of startsets used per dimension of simfun}

\item{init.perc}{numeric; percentage of evaluations used for the initialization phase}

\item{setsize}{The number of draws from the simfun in each iteration}

\item{continue}{Object of class designresult as created by the find.design function. Will be used to continue the search, using all collected simulation results so far.}

\item{dat}{list of data from a previous design result.}

\item{silent}{logical; suppresses output during the search.}

\item{autosave_dir}{character; file location for saving the dat object after each update.}

\item{control}{list specifying arguments passed to the surrogate models. For example, list(covtype='gauss') can be used with the gpr surrogate to use a different covariance structure than the default.}
}
\value{
function returns an object of class designresult
}
\description{
Perform a surrogate modeling approach to search for optimal study design parameters. For further guidance on how to use the package and the \code{find.design} function specifically, see the \href{https://github.com/flxzimmer/mlpwr}{Readme.md file}.
}
\examples{
\donttest{
#Load a simulation function
simfun = example.simfun('ttest')
# Perform the search
ds = find.design(simfun = simfun, boundaries = c(100,300), power = .95)
# Output the results
summary(ds)
# Plot results
plot(ds)

# Two-dimensional simulation function:
simfun = example.simfun('anova')
# Perform the search
res = find.design(simfun = simfun,
 costfun = function(n,n.groups) 5*n+20*n.groups,
 boundaries = list(n = c(10, 150), n.groups = c(5, 30)),
 power = .95)
# Output the results
summary(ds)
# Plot results
plot(ds)
}
}
