% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{mp_corr_func}
\alias{mp_corr_func}
\alias{random}
\alias{fixed}
\title{Functions for Generating Correlations}
\usage{
random(lower, upper)

fixed(value)
}
\arguments{
\item{lower}{the lower bound of the distribution.}

\item{upper}{the upper bound of the distribution.}

\item{value}{the fixed value for the correlation.}
}
\value{
A \code{mp_corr_func} that generates the desired correlation
}
\description{
Specify a random correlation that is uniform between \code{lower} and \code{upper}
}
\examples{
# Create Model with random and fixed correlations
(
    outcome('Y')
    + within_predictor('X')
    + between_predictor('Z')
    + effect_size(icc = 0.1)
    # Defaults
    + correlations(
        within  = random(0.1, 0.3),
        between = fixed(0.2)
    )
)
}
\seealso{
\code{\link[=correlations]{correlations()}}
}
