% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{reliability}
\alias{reliability}
\title{Calculate reliability coefficients for random effects}
\usage{
reliability(model)
}
\arguments{
\item{model}{A model produced using the \code{lme4::lmer()} or \code{lme4::glmer()} functions. This is an object of class \code{merMod} and subclass \code{lmerMod} or \code{glmerMod}.}
}
\value{
A list with reliability estimates for each random effect
}
\description{
This function computes reliability coefficients for random effects according to Raudenbush and Bryk (2002) and Snijders and Bosker (2012). The reliability coefficient is equal to the proportion of between group variance to total variance: \eqn{\frac{\tau^2}{\tau^2 + {\frac{\sigma^2}{n_j}}}}.
The empirical Bayes estimator for the random effect is a weighted combination of the cluster mean and grand mean with the weight given by the reliability of the random effect. We refer to this as a reliability because in classical test theory the ratio of the true score variance, \eqn{\tau^2}, relative to the observed score variance of the sample mean is a reliability.
A reliability close to 1 puts more weight on the cluster mean while a reliability close to 0 put more weight on the grand mean.
}
\examples{

# lmer model
fit <- lme4::lmer(mathach ~ 1 + ses + catholic + (1 + ses|id),
data=hsb, REML=TRUE)

reliability(fit)


}
\references{
{
\insertRef{snijders2012}{mlmhelpr}
}

{
\insertRef{raudenbush2002}{mlmhelpr}
}
}
