% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{executeAlgorithm}
\alias{executeAlgorithm}
\title{Auxiliary function used by resample. It executes an algorithm, given as a string, and stores the resulting MLD in a arff file}
\usage{
executeAlgorithm(
  D,
  a,
  P,
  k,
  TH,
  outputDirectory,
  neighbors,
  neighbors2,
  tableVDM
)
}
\arguments{
\item{D}{mld \code{mldr} object with the multilabel dataset to preprocess}

\item{a}{String with the name of the algorithm to be applied.}

\item{P}{Percentage in which the original dataset is increased/decreased (if required by the algorithm)}

\item{k}{Number of neighbors taken into account for each instance (if required by the algorithm)}

\item{TH}{Threshold for the Hamming Distance in order to consider an instance different to another one (if required by the algorithm)}

\item{outputDirectory}{Route with the directory where the generated ARFF file will be stored}

\item{neighbors}{Structure with all instances and neighbors in the dataset, useful in MLSOL and MLUL}

\item{neighbors2}{Structure with some instances and neighbors in the dataset, useful in MLeNN and MLTL}

\item{tableVDM}{Dataframe object containing previous calculations for faster processing. If it is empty, the algorithm will be slower}
}
\value{
Time (in seconds) taken to execute the algorithm (NULL if no algorithm was executed)
}
\description{
Auxiliary function used by resample. It executes an algorithm, given as a string, and stores the resulting MLD in a arff file
}
