% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_time_norm_focus.R
\name{f_time_norm_focus}
\alias{f_time_norm_focus}
\alias{f_time_norm_focus.numeric}
\alias{f_time_norm_focus.mkindsg}
\title{Normalisation factors for aerobic soil degradation according to FOCUS guidance}
\usage{
f_time_norm_focus(object, ...)

\method{f_time_norm_focus}{numeric}(
  object,
  moisture = NA,
  field_moisture = NA,
  temperature = object,
  Q10 = 2.58,
  walker = 0.7,
  f_na = NA,
  ...
)

\method{f_time_norm_focus}{mkindsg}(
  object,
  study_moisture_ref_source = c("auto", "meta", "focus"),
  Q10 = 2.58,
  walker = 0.7,
  f_na = NA,
  ...
)
}
\arguments{
\item{object}{An object containing information used for the calculations}

\item{\dots}{Currently not used}

\item{moisture}{Numeric vector of moisture contents in \\\% w/w}

\item{field_moisture}{Numeric vector of moisture contents at field capacity
(pF2) in \\\% w/w}

\item{temperature}{Numeric vector of temperatures in °C}

\item{Q10}{The Q10 value used for temperature normalisation}

\item{walker}{The Walker exponent used for moisture normalisation}

\item{f_na}{The factor to use for NA values. If set to NA, only factors
for complete cases will be returned.}

\item{study_moisture_ref_source}{Source for the reference value
used to calculate the study moisture. If 'auto', preference is given
to a reference moisture given in the meta information, otherwise
the focus soil moisture for the soil class is used}
}
\description{
Time step normalisation factors for aerobic soil degradation as described
in Appendix 8 to the FOCUS kinetics guidance (FOCUS 2014, p. 369).
}
\examples{
f_time_norm_focus(25, 20, 25) # 1.37, compare FOCUS 2014 p. 184

D24_2014$meta
# No moisture normalisation in the first dataset, so we use f_na = 1 to get
# temperature only normalisation as in the EU evaluation
f_time_norm_focus(D24_2014, study_moisture_ref_source = "focus", f_na = 1)
}
\references{
FOCUS (2006) \dQuote{Guidance Document on Estimating Persistence
and Degradation Kinetics from Environmental Fate Studies on Pesticides in
EU Registration} Report of the FOCUS Work Group on Degradation Kinetics,
EC Document Reference Sanco/10058/2005 version 2.0, 434 pp,
\url{http://esdac.jrc.ec.europa.eu/projects/degradation-kinetics}
FOCUS (2014) \dQuote{Generic guidance for Estimating Persistence
and Degradation Kinetics from Environmental Fate Studies on Pesticides in
EU Registration} Report of the FOCUS Work Group on Degradation Kinetics,
Version 1.1, 18 December 2014
\url{http://esdac.jrc.ec.europa.eu/projects/degradation-kinetics}
}
\seealso{
\link{focus_soil_moisture}
}
