% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.saem.mmkin.R
\name{summary.saem.mmkin}
\alias{summary.saem.mmkin}
\alias{print.summary.saem.mmkin}
\title{Summary method for class "saem.mmkin"}
\usage{
\method{summary}{saem.mmkin}(object, data = FALSE, verbose = FALSE, distimes = TRUE, ...)

\method{print}{summary.saem.mmkin}(x, digits = max(3, getOption("digits") - 3), verbose = x$verbose, ...)
}
\arguments{
\item{object}{an object of class \link{saem.mmkin}}

\item{data}{logical, indicating whether the full data should be included in
the summary.}

\item{verbose}{Should the summary be verbose?}

\item{distimes}{logical, indicating whether DT50 and DT90 values should be
included.}

\item{\dots}{optional arguments passed to methods like \code{print}.}

\item{x}{an object of class \link{summary.saem.mmkin}}

\item{digits}{Number of digits to use for printing}
}
\value{
The summary function returns a list based on the \link[saemix:SaemixObject-class]{saemix::SaemixObject}
obtained in the fit, with at least the following additional components
\item{saemixversion, mkinversion, Rversion}{The saemix, mkin and R versions used}
\item{date.fit, date.summary}{The dates where the fit and the summary were
produced}
\item{diffs}{The differential equations used in the degradation model}
\item{use_of_ff}{Was maximum or minimum use made of formation fractions}
\item{data}{The data}
\item{confint_trans}{Transformed parameters as used in the optimisation, with confidence intervals}
\item{confint_back}{Backtransformed parameters, with confidence intervals if available}
\item{confint_errmod}{Error model parameters with confidence intervals}
\item{ff}{The estimated formation fractions derived from the fitted
model.}
\item{distimes}{The DT50 and DT90 values for each observed variable.}
\item{SFORB}{If applicable, eigenvalues of SFORB components of the model.}
The print method is called for its side effect, i.e. printing the summary.
}
\description{
Lists model equations, initial parameter values, optimised parameters
for fixed effects (population), random effects (deviations from the
population mean) and residual error model, as well as the resulting
endpoints such as formation fractions and DT50 values. Optionally
(default is FALSE), the data are listed in full.
}
\examples{
# Generate five datasets following DFOP-SFO kinetics
sampling_times = c(0, 1, 3, 7, 14, 28, 60, 90, 120)
dfop_sfo <- mkinmod(parent = mkinsub("DFOP", "m1"),
 m1 = mkinsub("SFO"), quiet = TRUE)
set.seed(1234)
k1_in <- rlnorm(5, log(0.1), 0.3)
k2_in <- rlnorm(5, log(0.02), 0.3)
g_in <- plogis(rnorm(5, qlogis(0.5), 0.3))
f_parent_to_m1_in <- plogis(rnorm(5, qlogis(0.3), 0.3))
k_m1_in <- rlnorm(5, log(0.02), 0.3)

pred_dfop_sfo <- function(k1, k2, g, f_parent_to_m1, k_m1) {
  mkinpredict(dfop_sfo,
    c(k1 = k1, k2 = k2, g = g, f_parent_to_m1 = f_parent_to_m1, k_m1 = k_m1),
    c(parent = 100, m1 = 0),
    sampling_times)
}

ds_mean_dfop_sfo <- lapply(1:5, function(i) {
  mkinpredict(dfop_sfo,
    c(k1 = k1_in[i], k2 = k2_in[i], g = g_in[i],
      f_parent_to_m1 = f_parent_to_m1_in[i], k_m1 = k_m1_in[i]),
    c(parent = 100, m1 = 0),
    sampling_times)
})
names(ds_mean_dfop_sfo) <- paste("ds", 1:5)

ds_syn_dfop_sfo <- lapply(ds_mean_dfop_sfo, function(ds) {
  add_err(ds,
    sdfunc = function(value) sqrt(1^2 + value^2 * 0.07^2),
    n = 1)[[1]]
})

\dontrun{
# Evaluate using mmkin and saem
f_mmkin_dfop_sfo <- mmkin(list(dfop_sfo), ds_syn_dfop_sfo,
  quiet = TRUE, error_model = "tc", cores = 5)
f_saem_dfop_sfo <- saem(f_mmkin_dfop_sfo)
summary(f_saem_dfop_sfo, data = TRUE)
}

}
\author{
Johannes Ranke for the mkin specific parts
saemix authors for the parts inherited from saemix.
}
