% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw.R
\name{aw}
\alias{aw}
\alias{aw.mkinfit}
\alias{aw.mmkin}
\title{Calculate Akaike weights for model averaging}
\usage{
aw(object, ...)

\method{aw}{mkinfit}(object, ...)

\method{aw}{mmkin}(object, ...)
}
\arguments{
\item{object}{An \link{mmkin} column object, containing two or more
\link{mkinfit} models that have been fitted to the same data,
or an mkinfit object. In the latter case, further mkinfit
objects fitted to the same data should be specified
as dots arguments.}

\item{\dots}{Not used in the method for \link{mmkin} column objects,
further \link{mkinfit} objects in the method for mkinfit objects.}
}
\description{
Akaike weights are calculated based on the relative
expected Kullback-Leibler information as specified
by Burnham and Anderson (2004).
}
\examples{
\dontrun{
f_sfo <- mkinfit("SFO", FOCUS_2006_D, quiet = TRUE)
f_dfop <- mkinfit("DFOP", FOCUS_2006_D, quiet = TRUE)
aw_sfo_dfop <- aw(f_sfo, f_dfop)
sum(aw_sfo_dfop)
aw_sfo_dfop # SFO gets more weight as it has less parameters and a similar fit
f <- mmkin(c("SFO", "FOMC", "DFOP"), list("FOCUS D" = FOCUS_2006_D), cores = 1, quiet = TRUE)
aw(f)
sum(aw(f))
aw(f[c("SFO", "DFOP")])
}
}
\references{
Burnham KP and Anderson DR (2004) Multimodel
Inference: Understanding AIC and BIC in Model Selection.
\emph{Sociological Methods & Research} \strong{33}(2) 261-304
}
