% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrtest.mkinfit.R
\name{lrtest.mkinfit}
\alias{lrtest.mkinfit}
\title{Likelihood ratio test for mkinfit models}
\usage{
\method{lrtest}{mkinfit}(object, object_2 = NULL, ...)
}
\arguments{
\item{object}{An \code{\link{mkinfit}} object}

\item{object_2}{Optionally, another mkinfit object fitted to the same data.}

\item{\dots}{Argument to \code{\link{mkinfit}}, passed to
\code{\link{update.mkinfit}} for creating the alternative fitted object.}
}
\description{
Compare two mkinfit models based on their likelihood. If two fitted
mkinfit objects are given as arguments, it is checked if they have been
fitted to the same data. It is the responsibility of the user to make sure
that the models are nested, i.e. one of them has less degrees of freedom
and can be expressed by fixing the parameters of the other.
}
\details{
Alternatively, an argument to mkinfit can be given which is then passed
to \code{\link{update.mkinfit}} to obtain the alternative model.

The comparison is then made by the \code{\link[lmtest]{lrtest.default}}
method from the lmtest package. The model with the higher number of fitted
parameters (alternative hypothesis) is listed first, then the model with the
lower number of fitted parameters (null hypothesis).
}
\examples{
\dontrun{
test_data <- subset(synthetic_data_for_UBA_2014[[12]]$data, name == "parent")
sfo_fit <- mkinfit("SFO", test_data, quiet = TRUE)
dfop_fit <- mkinfit("DFOP", test_data, quiet = TRUE)
lrtest(dfop_fit, sfo_fit)
lrtest(sfo_fit, dfop_fit)

# The following two examples are commented out as they fail during
# generation of the static help pages by pkgdown
# lrtest(dfop_fit, error_model = "tc")
# lrtest(dfop_fit, fixed_parms = c(k2 = 0))
}
}
