% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_mat.R
\name{age_mat_vB}
\alias{age_mat_vB}
\title{Calculate age at maturity from von Bertalanffy growth parameters}
\usage{
age_mat_vB(object)
}
\arguments{
\item{object}{A MizerParams object or a species_params data frame}
}
\value{
A named vector. The names are the species names and the values are
the ages at maturity.
}
\description{
This is not a good way to determine the age at maturity because the von
Bertalanffy growth curve is not reliable for larvae and juveniles. However
this was used in previous versions of mizer and is supplied for
backwards compatibility.
}
\details{
Uses the age at maturity that is implied by the von Bertalanffy growth curve
specified by the \code{w_inf}, \code{k_vb}, \code{t0}, \code{a} and \code{b} parameters in the
species_params data frame.

If any of \code{k_vb} is missing for a species, the function returns NA for that
species. Default values of \code{b = 3} and \code{t0 = 0} are used if these are
missing. If \code{w_inf} is missing, \code{w_max} is used instead.
}
\concept{helper}
