% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMaxIntakeRate.R
\name{setMaxIntakeRate}
\alias{setMaxIntakeRate}
\alias{getMaxIntakeRate}
\alias{intake_max}
\alias{intake_max<-}
\title{Set maximum intake rate}
\usage{
setMaxIntakeRate(params, intake_max = NULL, reset = FALSE, ...)

getMaxIntakeRate(params)

intake_max(params)

intake_max(params) <- value
}
\arguments{
\item{params}{MizerParams}

\item{intake_max}{Optional. An array (species x size) holding the maximum
intake rate for each species at size. If not supplied, a default is set as
described in the section "Setting maximum intake rate".}

\item{reset}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
If set to TRUE, then the intake rate will be reset to the value
calculated from the species parameters, even if it was previously
overwritten with a custom value. If set to FALSE (default) then a
recalculation from the species parameters will take place only if no
custom value has been set.}

\item{...}{Unused}

\item{value}{intake_max}
}
\value{
\code{setReproduction()}: A MizerParams object with updated maximum
intake rate.

\code{getMaxIntakeRate()} or equivalently \code{intake_max()}: An array
(species x size) with the maximum intake rate.
}
\description{
Set maximum intake rate
}
\section{Setting maximum intake rate}{

The maximum intake rate \eqn{h_i(w)} of an individual of species \eqn{i} and
weight \eqn{w} determines the feeding level, calculated with
\code{\link[=getFeedingLevel]{getFeedingLevel()}}. It is measured in grams/year.

If the \code{intake_max} argument is not supplied, then the maximum intake
rate is set to \deqn{h_i(w) = h_i w^{n_i}.}
The values of \eqn{h_i} (the maximum intake rate of an individual of size 1
gram) and \eqn{n_i} (the allometric exponent for the intake rate) are taken
from the \code{h} and \code{n} columns in the species parameter dataframe. If
the \code{h} column is not supplied in the species parameter dataframe, it is
calculated by the \code{\link[=get_h_default]{get_h_default()}} function.

If \eqn{h_i} is set to \code{Inf}, fish of species i will consume all encountered
food.
}

\seealso{
Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
