% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerFMortGear}
\alias{mizerFMortGear}
\title{Get the fishing mortality needed to project
standard mizer model}
\usage{
mizerFMortGear(params, effort)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{effort}{A vector with the effort for each fishing gear.}
}
\value{
An three dimensional array (gear x species x size) with the
fishing mortality
}
\description{
Calculates the fishing mortality rate \eqn{F_{g,i,w}} by gear, species and
size.
This is a helper function for \code{\link[=mizerFMort]{mizerFMort()}}.
}
\note{
Here: fishing mortality = catchability x selectivity x effort.
}
\seealso{
\code{\link[=setFishing]{setFishing()}}

Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
