% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getEGrowth}
\alias{getEGrowth}
\title{Get energy rate available for growth}
\usage{
getEGrowth(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  t = 0,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{...}{Unused}
}
\value{
A two dimensional array (prey species x prey size)
}
\description{
Calculates the energy rate \eqn{g_i(w)} (grams/year) available by species and
size for growth after metabolism, movement and reproduction have been
accounted for.
}
\section{Your own growth rate function}{

By default \code{\link[=getEGrowth]{getEGrowth()}} calls \code{\link[=mizerEGrowth]{mizerEGrowth()}}. However you can
replace this with your own alternative growth rate function. If
your function is called \code{"myEGrowth"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "EGrowth", "myEGrowth")
}

Your function will then be called instead of \code{\link[=mizerEGrowth]{mizerEGrowth()}}, with the
same arguments.
}

\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getEGrowth(params, n = N(sim)[15, , ], n_pp = NResource(sim)[15, ], t = 15)
}
}
\seealso{
\code{\link[=getERepro]{getERepro()}}, \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}

Other rate functions: 
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getRates}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
