% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effsize.R
\name{effsize}
\alias{effsize}
\title{Effect Sizes for Categorical Variables}
\usage{
effsize(..., data = NULL, type = c("phi", "cramer", "tschuprow", "cont", "w", "fei"),
        alternative = c("two.sided", "less", "greater"),   conf.level = 0.95,
        adjust = TRUE, indep = TRUE, p = NULL, digits = 3, as.na = NULL,
        write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{...}{a vector, factor, matrix or data frame. Alternatively, an
expression indicating the variable names in \code{data} e.g.,
\code{as.na(x1, x2, data = dat)}. When specifying more than
one variable, the first variable is always the focal variable
in the Chi-square test of independence which association with
all other variables is investigated. Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see
'Details' in the \code{\link{df.subset}} function.}

\item{data}{a data frame when specifying one or more variables in the
argument \code{...}. Note that the argument is \code{NULL}
when specifying a vector, factor, matrix, array, data frame,
or list for the argument \code{...}.}

\item{type}{a character string indicating the type of effect size, i.e.,
\code{phi} for phi coefficient, \code{cramer} for Cramer's
V, \code{tschuprow} for Tschuprow’s T, \code{cont} for
Pearson's contingency coefficient, \code{w} for Cohen's w,
and \code{Fei} for Fei.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"}
or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence
level of the interval.}

\item{adjust}{logical: if \code{TRUE} (default), phi coefficient and
Pearson's contingency coefficient are adjusted by relating
the coefficient to the possible maximum, or Cramer's \emph{V}
and Tschuprow’s \emph{T} are corrected for small-sample bias.}

\item{indep}{logical: if \code{TRUE}, effect size computation is based
on a chi-square test of independence (default when specifying
two variable in \code{...}), if \code{FALSE} effect size
computation is based on a chi-square goodness-of-fit test
(default when specifying one variable in \code{...}).}

\item{p}{a numeric vector specifying the expected proportions in
each category of the categorical variable when conducting a
chi-square goodness-of-fit test. By default, the expected
proportions in each category are assumed to be equal.}

\item{digits}{an integer value indicating the number of decimal places
digits to be used for displaying the results.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before
conducting the analysis.}

\item{write}{a character string naming a file for writing the output
into either a text file with file extension \code{".txt"}
(e.g., \code{"Output.txt"}) or Excel file with file
extension \code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If
the file name does not contain any file extension, an Excel
file will be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\description{
This function computes effect sizes for one or more than one categorical
variable, i.e., (adjusted) phi coefficient, (bias-corrected) Cramer's \emph{V},
(bias-corrected) Tschuprow's \emph{T}, (adjusted) Pearson's contingency
coefficient, Cohen's \emph{w}), and \emph{Fei}. By default, the function
computes \emph{Fei} based on a chi-square goodness-of-fit test for one
categorical variable, phi coefficient based on a chi-square test of
independence for two dichotomous variables, and Cramer's \emph{V} based on a
chi-square test of independence for two variables with at least one polytomous
variable.
}
\note{
This function is based on modified copies of the functions \code{chisq_to_phi},
\code{chisq_to_cramers_v}, \code{chisq_to_tschuprows_t}, \code{chisq_to_pearsons_c},
\code{chisq_to_cohens_w}, and \code{chisq_to_fei} from the \pkg{effectsize}
package (Ben-Shachar, Lüdecke & Makowski, 2020).
}
\examples{
# Example 1a: Phi coefficient for 'vs' and 'am'
effsize(mtcars[, c("vs", "am")])

# Example 1a: Alternative specification using the 'data' argument
effsize(vs, am, data = mtcars)

# Example 2: Bias-corrected Cramer's V for 'gear' and 'carb'
effsize(gear, carb, data = mtcars)

# Example 3: Cramer's V (without bias-correction) for 'gear' and 'carb'
effsize(gear, carb, data = mtcars, adjust = FALSE)

# Example 4: Adjusted Pearson's contingency coefficient for 'gear' and 'carb'
effsize(gear, carb, data = mtcars, type = "cont")

# Example 5: Fei for 'gear'
effsize(gear, data = mtcars)

# Example 6a: Bias-corrected Cramer's V for 'cyl' and 'vs', 'am', 'gear', and 'carb'
effsize(mtcars[, c("cyl", "vs", "am", "gear", "carb")])

# Example 6b: Alternative specification using the 'data' argument
effsize(cyl, vs:carb, data = mtcars)

\dontrun{
# Example 7b: Write Results into a text file
effsize(cyl, vs:carb, data = mtcars, write = "Cramer.txt")

# Example 7b: Write Results into a Excel file
effsize(cyl, vs:carb, data = mtcars, write = "Cramer.xlsx")
}
}
\references{
Bergsma, W. (2013). A bias correction for Cramer's V and Tschuprow's T.
\emph{Journal of the Korean Statistical Society, 42}, 323-328.
https://doi.org/10.1016/j.jkss.2012.10.002

Ben-Shachar M. S., Lüdecke D., Makowski D. (2020). effectsize: Estimation of Effect
Size Indices and Standardized Parameters. \emph{Journal of Open Source Software, 5}
(56), 2815. https://doi.org/10.21105/joss.02815

Ben-Shachar, M. S., Patil, I., Theriault, R., Wiernik, B. M., Lüdecke, D. (2023).
Phi, Fei, Fo, Fum: Effect sizes for categorical data that use the chi-squared
statistic. \emph{Mathematics, 11}, 1982. https://doi.org/10.3390/math11091982

Cureton, E. E. (1959). Note on Phi/Phi max. \emph{Psychometrika, 24}, 89-91.

Davenport, E. C., & El-Sanhurry, N. A. (1991). Phi/Phimax: Review and synthesis.
\emph{Educational and Psychological Measurement, 51}, 821-828.
https://doi.org/10.1177/001316449105100403

Sakoda, J.M. (1977). Measures of association for multivariate contingency tables.
\emph{Proceedings of the Social Statistics Section of the American Statistical
Association (Part III)}, 777-780.
}
\seealso{
\code{\link{cor.matrix}}, \code{\link{cohens.d}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
