% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.prop.R
\name{size.prop}
\alias{size.prop}
\title{Sample Size Determination for Testing Proportions}
\usage{
size.prop(pi = 0.5, delta, sample = c("two.sample", "one.sample"),
          alternative = c("two.sided", "less", "greater"),
          alpha = 0.05, beta = 0.1, correct = FALSE,
          write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{pi}{a number indicating the true value of the probability under the null hypothesis (one-sample test), \eqn{\pi}.0
or a number indicating the true value of the probability in group 1 (two-sample test), \eqn{\pi}.1.}

\item{delta}{minimum difference to be detected, \eqn{\delta}.}

\item{sample}{a character string specifying one- or two-sample proportion test,
must be one of \code{"two.sample"} (default) or \code{"one.sample"}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"less"} or \code{"greater"}.}

\item{alpha}{type-I-risk, \eqn{\alpha}.}

\item{beta}{type-II-risk, \eqn{\beta}.}

\item{correct}{a logical indicating whether continuity correction should be applied.}

\item{write}{a character string naming a text file with file extension
\code{".txt"} (e.g., \code{"Output.txt"}) for writing the
output into a text file.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{matrix or data frame specified in \code{x}}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{list with the result, i.e., optimal sample size}
}
\description{
This function performs sample size computation for the one-sample and two-sample test for proportions
based on precision requirements (i.e., type-I-risk, type-II-risk and an effect size).
}
\examples{
#-------------------------------------------------------------------------------
# Example 1: Two-sided one-sample test
# H0: pi = 0.5, H1: pi != 0.5
# alpha = 0.05, beta = 0.2, delta = 0.2

size.prop(pi = 0.5, delta = 0.2, sample = "one.sample",
          alternative = "two.sided", alpha = 0.05, beta = 0.2)

#-------------------------------------------------------------------------------
# Example 2: Two-sided one-sample test
# H0: pi = 0.5, H1: pi != 0.5
# alpha = 0.05, beta = 0.2, delta = 0.2
# with continuity correction

size.prop(pi = 0.5, delta = 0.2, sample = "one.sample",
          alternative = "two.sided", alpha = 0.05, beta = 0.2,
          correct = TRUE)

#-------------------------------------------------------------------------------
# Example 3: One-sided one-sample test
# H0: pi <= 0.5, H1: pi > 0.5
# alpha = 0.05, beta = 0.2, delta = 0.2

size.prop(pi = 0.5, delta = 0.2, sample = "one.sample",
          alternative = "less", alpha = 0.05, beta = 0.2)

#-------------------------------------------------------------------------------
# Example 4: Two-sided two-sample test
# H0: pi.1 = pi.2 = 0.5, H1: pi.1 != pi.2
# alpha = 0.01, beta = 0.1, delta = 0.2

size.prop(pi = 0.5, delta = 0.2, sample = "two.sample",
          alternative = "two.sided", alpha = 0.01, beta = 0.1)

#-------------------------------------------------------------------------------
# Example 5: One-sided two-sample test
# H0: pi.1 <=  pi.1 = 0.5, H1: pi.1 > pi.2
# alpha = 0.01, beta = 0.1, delta = 0.2

size.prop(pi = 0.5, delta = 0.2, sample = "two.sample",
          alternative = "greater", alpha = 0.01, beta = 0.1)
}
\references{
Fleiss, J. L., Levin, B., & Paik, M. C. (2003). \emph{Statistical methods for rates and proportions} (3rd ed.).
John Wiley & Sons.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.

Rasch, D., Pilz, J., Verdooren, L. R., & Gebhardt, G. (2011).
\emph{Optimal experimental design with R}. Chapman & Hall/CRC.
}
\seealso{
\code{\link{size.mean}}, \code{\link{size.cor}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
