% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.prop.R
\name{ci.prop}
\alias{ci.prop}
\title{Confidence Interval for Proportions}
\usage{
ci.prop(x, method = c("wald", "wilson"),
        alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
        group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE,
        digits = 3, as.na = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame with numeric variables with 0 and 1 values,
i.e., factors and character variables are excluded from \code{x} before conducting
the analysis.}

\item{method}{a character string specifying the method for computing the confidence interval,
must be one of \code{"wald"}, or \code{"wilson"} (default).}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}

\item{group}{a numeric vector, character vector or factor as grouping variable.}

\item{split}{a numeric vector, character vector or factor as split variable.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before conducting the analysis
(i.e., listwise deletion) when specifying more than one outcome variable.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to \code{x}, but
not to \code{group} or \code{split}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, list with the input specified in \code{x},
\code{group}, and \code{split} (\code{data}), specification of function arguments (\code{args}),
and result table (\code{result}).
}
\description{
This function computes a confidence interval for proportions for one or more variables, optionally
by a grouping and/or split variable.
}
\details{
The Wald confidence interval which is based on the normal approximation to the binomial distribution are
computed by specifying \code{method = "wald"}, while the Wilson (1927) confidence interval (aka Wilson
score interval) is requested by specifying \code{method = "wilson"}. By default, Wilson confidence
interval is computed which have been shown to be reliable in small samples of n = 40 or less, and
larger samples of n > 40 (Brown, Cai & DasGupta, 2001), while the Wald confidence intervals is
inadequate in small samples and when \emph{p} is near 0 or 1 (Agresti & Coull, 1998).
}
\examples{
dat <- data.frame(group1 = c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
                  group2 = c(1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2),
                  x1 = c(0, 1, 0, 0, 1, 1, 0, 1, NA, 0, 1, 0),
                  x2 = c(0, NA, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1),
                  x3 = c(1, 1, 1, 0, 1, NA, 1, NA, 0, 0, 0, 1))

# Two-Sided 95\% CI for x1
ci.prop(dat$x1)

# Two-Sided 95\% CI for x1 using Wald method
ci.prop(dat$x1, method = "wald")

# One-Sided 95\% CI for x1
ci.prop(dat$x1, alternative = "less")

# Two-Sided 99\% CI
ci.prop(dat$x1, conf.level = 0.99)

# Two-Sided 95\% CI, print results with 4 digits
ci.prop(dat$x1, digits = 4)

# Two-Sided 95\% CI for x1, x2, and x3,
# listwise deletion for missing data
ci.prop(dat[, c("x1", "x2", "x3")], na.omit = TRUE)

# Two-Sided 95\% CI for x1, x2, and x3,
# analysis by group1 separately
ci.prop(dat[, c("x1", "x2", "x3")], group = dat$group1)

# Two-Sided 95\% CI for x1, x2, and x3,
# analysis by group1 separately, sort by variables
ci.prop(dat[, c("x1", "x2", "x3")], group = dat$group1, sort.var = TRUE)

# Two-Sided 95\% CI for x1, x2, and x3,
# split analysis by group1
ci.prop(dat[, c("x1", "x2", "x3")], split = dat$group1)

# Two-Sided 95\% CI for x1, x2, and x3,
# analysis by group1 separately, split analysis by group2
ci.prop(dat[, c("x1", "x2", "x3")],
        group = dat$group1, split = dat$group2)
}
\references{
Agresti, A. & Coull, B.A. (1998). Approximate is better than "exact" for interval estimation of binomial
proportions. \emph{American Statistician, 52}, 119-126.

Brown, L. D., Cai, T. T., & DasGupta, A., (2001). Interval estimation for a binomial proportion.
\emph{Statistical Science, 16}, 101-133.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.

Wilson, E. B. (1927). Probable inference, the law of succession, and statistical inference.
\emph{Journal of the American Statistical Association, 22}, 209-212.
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}}, \code{\link{ci.prop.diff}},
\code{\link{ci.var}}, \code{\link{ci.sd}}, \code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
