% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.misty.object.R
\name{print.misty.object}
\alias{print.misty.object}
\title{Print misty.object object}
\usage{
\method{print}{misty.object}(x, print = x$args$print, tri = x$args$tri,
      freq = x$args$freq, split = x$args$split, table = x$args$table,
      digits = x$args$digits, p.digits = x$args$p.digits,
      icc.digits = x$args$icc.digits, sort.var = x$args$sort.var,
      order = x$args$order, check = TRUE, ...)
}
\arguments{
\item{x}{\code{misty.object} object.}

\item{print}{a character string or character vector indicating which results to to be printed
on the console.}

\item{tri}{a character string or character vector indicating which triangular of the matrix
to show on the console, i.e., \code{both} for upper and lower triangular,
\code{lower} for the lower triangular, and \code{upper} for the upper
triangular.}

\item{freq}{logical: if \code{TRUE}, absolute frequencies will be included in the cross
tabulation (\code{freq()} function).}

\item{split}{logical: if \code{TRUE}, cross table is split in absolute frequencies and percentage(s)
(\code{crosstab()} function).}

\item{table}{logical: if \code{TRUE}, a frequency table with number of observed values (\code{"nObs"}),
percent of observed values (\code{"pObs"}), number of missing values (\code{"nNA"}), and
percent of missing values (\code{"pNA"}) is printed for each variable on the console
(\code{na.descript()} function).}

\item{digits}{an integer value indicating the number of decimal places digits to be used for
displaying results.}

\item{p.digits}{an integer indicating the number of decimal places to be used for displaying
\emph{p}-values.}

\item{icc.digits}{an integer indicating the number of decimal places to be used for displaying
intraclass correlation coefficients (\code{multilevel.descript()} function).}

\item{sort.var}{logical: if \code{TRUE}, output is sorted by variables.}

\item{order}{logical: if \code{TRUE}, variables are ordered from left to right in increasing order
of missing values (\code{na.descript()} function).}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{misty.object} object
}
\seealso{
\code{\link{alpha.coef}}, \code{\link{ci.mean.diff}}, \code{\link{ci.mean}}, \code{\link{ci.median}},
\code{\link{ci.prop.diff}}, \code{\link{ci.prop}}, \code{\link{ci.sd}}, \code{\link{ci.var}},
\code{\link{cohens.d}}, \code{\link{collin.diag}}, \code{\link{cont.coef}}, \code{\link{cor.matrix}},
\code{\link{cramers.v}}, \code{\link{crosstab}}, \code{\link{descript}}, \code{\link{eta.sq}},
\code{\link{freq}}, \code{\link{levenes.test}}, \code{\link{multilevel.descript}},
\code{\link{na.auxiliary}}, \code{\link{na.coverage}}, \code{\link{na.descript}},
\code{\link{na.pattern}}, \code{\link{omega.coef}}, \code{\link{phi.coef}}, \code{\link{poly.cor}},
\code{\link{size.cor}}, \code{\link{size.mean}}, \code{\link{size.prop}}, \code{\link{z.test}},
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
