% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.na.pattern.R
\name{print.na.pattern}
\alias{print.na.pattern}
\title{Print na.pattern}
\usage{
\method{print}{na.pattern}(x, order = x$args$order, digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{na.pattern} object.}

\item{order}{logical: if \code{TRUE}, variables are ordered from left to right in increasing order
of missing values.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying percentages.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{na.pattern} object
}
\examples{
dat <- data.frame(x = c(1, NA, NA, 6, 3),
                  y = c(7, NA, 8, 9, NA),
                  z = c(2, NA, 3, NA, 5))

# Compute a summary of missing data patterns
dat.pattern <- na.pattern(dat, output = FALSE)

# Print na.pattern object with 5 digits
print(dat.pattern, digits = 5)
}
\seealso{
\code{\link{na.pattern}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
