% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cramers.v.R
\name{print.cramers.v}
\alias{print.cramers.v}
\title{Print cramers.v object}
\usage{
\method{print}{cramers.v}(x, tri = x$args$tri, digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{cramers.v} object.}

\item{tri}{a character string or character vector indicating which triangular of the matrix
to show on the console, i.e., \code{both} for upper and lower triangular,
\code{lower} for the lower triangular, and \code{upper} for the upper
triangular.}

\item{digits}{an integer value indicating the number of decimal places digits to be used for
displaying Cramer's V.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{cramers.v} object
}
\examples{
dat <- data.frame(x = c(1, 1, 2, 1, 3, 3, 2, 2, 1, 2),
                  y = c(1, 2, 2, 1, 3, 4, 1, 2, 3, 1),
                  z = c(1, 1, 2, 1, 2, 3, 1, 2, 3, 2))

# Bias-corrected Cramer's V between x and y
dat.cramer <- cramers.v(dat[, c("x", "y")], output = FALSE)

# Print cramers.v object with 4 digits
print(dat.cramer, digits = 4)
}
\seealso{
\code{\link{cramers.v}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
