% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetropolisHastings.R
\name{MetropolisHastings}
\alias{MetropolisHastings}
\title{The modified Metropolis-Hastings algorithm}
\usage{
MetropolisHastings(
  x0,
  eval_x0 = -1,
  chain_length,
  modified = TRUE,
  sigma = 0.3,
  proposal = "Uniform",
  lambda = 1,
  limit_fun = function(x) {     -1 },
  burnin = 20,
  thinning = 4
)
}
\arguments{
\item{x0}{the starting point of the Markov chain}

\item{eval_x0}{the value of the limit-state function on \code{x0}}

\item{chain_length}{the length of the Markov chain. At the end the chain
will be chain_length + 1 long}

\item{modified}{a boolean to use either the original Metropolis-Hastings
transition kernel or the coordinate-wise one}

\item{sigma}{a radius parameter for the Gaussian or Uniform proposal}

\item{proposal}{either "Uniform" for a Uniform random variable in an interval
[-sigma, sigma] or "Gaussian" for a centred Gaussian random variable with
standard deviation sigma}

\item{lambda}{the coefficient to increase the likelihood ratio}

\item{limit_fun}{the limite-state function delimiting the domain to sample in}

\item{burnin}{a burnin parameter, ie a number of initial discards samples}

\item{thinning}{a thinning parameter, ie that one sample over \code{thinning}
samples is kept along the chain}
}
\value{
A list containing the following entries:
\item{points}{the generated Markov chain}
\item{eval}{the value of the limit-state function on the generated samples}
\item{acceptation}{the acceptation rate}
\item{Ncall}{the total number of call to the limit-state function}
\item{samples}{all the generated samples}
\item{eval_samples}{the evaluation of the limit-state function on the
\code{samples} samples}
}
\description{
The function implements the specific modified Metropolis-Hastings algorithm
as described first by Au and Beck and including another scaling parameter for an extended
search in initial steps of the \code{SMART} algorithm.
}
\details{
The modified Metropolis-Hastings algorithm is supposed to be used in the
Gaussian standard space. Instead of using a proposed point for the multidimensional
Gaussian random variable, it applies a Metropolis step to each coordinate. Then it
generates the multivariate candidate by checking if it lies in the right domain.

This version proposed by Bourinet et al. includes an scaling parameter \code{lambda}.
This parameter is multiplied with the likelihood ratio in order to increase the chance
of accepting the candidate. While it biases the output distribution of the Markov chain,
the authors of \code{SMART} suggest its use (\code{lambda > 1}) for the exploration phase.
Note such a value disable to possiblity to use the output population for Monte Carlo
estimation.
}
