% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdist.R
\name{compdist}
\alias{compdist}
\alias{compdist.dist}
\alias{compdist.default}
\title{Creates an Object Representing Composite Distribution}
\usage{
compdist(..., weights, breakpoints, break.spec, all.left = FALSE)

\method{compdist}{dist}(..., weights, breakpoints, break.spec, all.left = FALSE)

\method{compdist}{default}(dist, params, weights, breakpoints, break.spec, all.left = FALSE, ...)
}
\arguments{
\item{...}{distribution objects.}

\item{weights}{vector of weights for the components.}

\item{breakpoints}{vector of breakpoints for the composite models, first and last breakpoints (\eqn{-\infty}, \eqn{\infty})
are assumed to be given, and should not be specified.}

\item{break.spec}{vector of breakpoints specifications with values "L" or "R", breakpoints specifications corresponding to
\eqn{-\infty} and \eqn{\infty} should not be specified.}

\item{all.left}{if TRUE, all break.spec are set to "L", default: FALSE.}

\item{dist}{vector of distribution names.}

\item{params}{list of parameters.}
}
\value{
Object of class compdist.
}
\description{
\code{compdist} creates an object which represents the composite distribution.
}
\details{
A CDF of a composite distribution function is \deqn{F(A)=\sum w_{i}F_{i}(A|B_{i})}, where
         \eqn{w_{i}} is the weight of the i-th component, \eqn{F_{i}()} is the CDF of the i-th component
         and \eqn{B_{i}} is the interval specified by the breakpoints. Clearly, the composite models are a
         specific case of the mixture models, where the corresponding probability distribution
         functions are truncated to some disjoint support.

         The objects can be specified in two ways, either the user may enter
         objects representing distributions or a vector of names and list of parameters.
         See the examples below.

         The argument \code{break.spec} defines if the breakpoint should be included to the distribution
         to the right ("R") or to the left ("L") of the breakpoint. This feature is of course useful
         only in the case where at least one of the adjacent components is discrete. By default
         the intervals are left-closed (all \code{break.spec} values are "R").

         The function permits to use the same breakpoint twice. This possibility
         allows to define a partition on a singleton, and hence to create a mass of probability.
         If this feature is used, the break.spec needs to be specified with "R" and "L", for
         the first and the second identical breakpoints, respectively, or not set at all.
}
\examples{
# using the objects
C <- compdist(normdist(1, 3), expdist(4), weights = c(0.7, 0.3), breakpoints = 2)
C

# using the names and parameters
C2 <- compdist(c("norm","exp"), list(c(mean = 1, sd = 3), c(rate = 4)),
              weights = c(0.7, 0.3), breakpoints = 2)
C2

# more complicated model where break.spec is useful
C3 <- compdist(-GPDdist(1,0.15,0.7), normdist(-1,1), binomdist(5,0.5),
              geomdist(0.3) + 2, weights = c(0.075, 0.425, 0.425, 0.075),
              breakpoints = c(-2.5, 0,3), break.spec = c("L", "R", "R"))
C3

# same breakpoint twice
C4 <-  compdist(-expdist(2),poisdist(),expdist(2),
                weights = c(0.25, 0.5, 0.25), breakpoints = c(0, 0))
C4
}
\seealso{
\code{\link{mixdist}}
}
