% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creators.R
\name{hyperdist}
\alias{hyperdist}
\title{Creates an Object Representing Hypergeometric Distribution}
\usage{
hyperdist(m = 10, n = 10, k = 5)
}
\arguments{
\item{m}{the number of white balls in the urn, default: 10.}

\item{n}{the number of black balls in the urn, default: 10.}

\item{k}{the number of balls drawn from the urn, default: 5.}
}
\value{
Object of class hyperdist.
}
\description{
The function creates an object which represents the hypergeometric distribution.
}
\details{
See \code{\link[stats]{Hypergeometric}}.
}
\examples{
H <- hyperdist(0.5)
d(H, c(2, 3, 4, NA))
r(H, 5)
}
\seealso{
\code{\link[stats]{Hypergeometric}}
}
