% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{md.exp}
\alias{md.exp}
\title{md.exp}
\usage{
md.exp(name, startcol, covariates, betas, lambda)
}
\arguments{
\item{name}{name of the column}

\item{startcol}{column name specifying individual study start dates or a start date}

\item{covariates}{names of covariate columns used}

\item{betas}{betas for the corresponding covariate columns}

\item{lambda}{baseline lambda}
}
\description{
Creates information of an event time variable distributed according to the specified exponential distribution.
This function call must be added to the \code{\link{md.simparams}} object.
}
\examples{

\dontrun{
library(missDeaths)

sim = md.simparams() +
  md.uniform("X1", 0.5) + 
    md.norm("X2") +
      md.exp("event", as.Date("1915-1-1"), c("X1", "X2"), c(0.1, 0.2), 0.05/365.2425)
}

}
