% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss.glm.R
\name{miss.glm}
\alias{miss.glm}
\title{Statistical Inference for Logistic Regression Models with Missing Values}
\usage{
miss.glm(formula, data, control = list(...), ...)
}
\arguments{
\item{formula}{an object of class "\code{\link[stats]{formula}}" : a symbolic description of the logistic regression model to be fitted.}

\item{data}{an optional data frame containing the variables in the model. If not found in \code{data}, the variables are taken from \code{environment}(\code{formula}), typically the environment from which \code{miss.glm} is called.}

\item{control}{a list of parameters for controlling the fitting process. For \code{miss.glm.fit} this is passed to \code{\link{miss.glm.control}}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
An object of class "\code{miss.glm}": a list with following components:
\item{coefficients}{Estimated \eqn{\beta}{\beta}.}
\item{ll}{Observed log-likelihood.}
\item{var.covar}{Variance-covariance matrix for estimated parameters.}
\item{s.err}{Standard error for estimated parameters.}
\item{mu.X}{Estimated \eqn{\mu}{\mu}.}
\item{Sig.X}{Estimated \eqn{\Sigma}{\Sigma}.}
\item{call}{the matched call.}
\item{formula}{the formula supplied.}
}
\description{
This function is used to perform statistical inference for logistic regression model with missing values, by algorithm SAEM.
}
\examples{
# Generate dataset
N <- 100  # number of subjects
p <- 3     # number of explanatory variables
mu.star <- rep(0,p)  # mean of the explanatory variables
Sigma.star <- diag(rep(1,p)) # covariance
beta.star <- c(1, 1,  0) # coefficients
beta0.star <- 0 # intercept
beta.true = c(beta0.star,beta.star)
X.complete <- matrix(rnorm(N*p), nrow=N)\%*\%chol(Sigma.star) +
              matrix(rep(mu.star,N), nrow=N, byrow = TRUE)
p1 <- 1/(1+exp(-X.complete\%*\%beta.star-beta0.star))
y <- as.numeric(runif(N)<p1)

# Generate missingness
p.miss <- 0.10
patterns <- runif(N*p)<p.miss #missing completely at random
X.obs <- X.complete
X.obs[patterns] <- NA

df.obs = data.frame(y,X.obs)

# SAEM
miss.list = miss.glm(y~., data=df.obs, print_iter=FALSE,seed=100)
print(miss.list)
print(summary(miss.list))
summary(miss.list)$coef
}
