% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{model_selection}
\alias{model_selection}
\title{model_selection}
\usage{
model_selection(X.obs, y, seed = 200)
}
\arguments{
\item{X.obs}{Design matrix with missingness \eqn{N \times p}{N * p}}

\item{y}{Response vector \eqn{N \times 1}{N * 1}}

\item{seed}{An integer as a seed set for the radom generator. The default value is 200.}
}
\value{
A list with components
\item{subset_choose}{The index of variates included in the best model selected.}
\item{beta}{Estimated \eqn{\beta}{\beta} for the best model.}
\item{sig2}{Estimated \eqn{\Sigma}{\Sigma} for the best model.}
\item{mu}{Estimated \eqn{\mu}{\mu} for the best model.}
}
\description{
Model selection for the logistic regression model with missing data.
}
\examples{
# Generate dataset
N <- 40  # number of subjects
p <- 3     # number of explanatory variables
mu.star <- rep(0,p)  # mean of the explanatory variables
Sigma.star <- diag(rep(1,p)) # covariance
beta.star <- c(1, 1,  0) # coefficients
beta0.star <- 0 # intercept
beta.true = c(beta0.star,beta.star)
X.complete <- matrix(rnorm(N*p), nrow=N)\%*\%chol(Sigma.star) +
              matrix(rep(mu.star,N), nrow=N, byrow = TRUE)
p1 <- 1/(1+exp(-X.complete\%*\%beta.star-beta0.star))
y <- as.numeric(runif(N)<p1)
# Generate missingness
p.miss <- 0.10
patterns <- runif(N*p)<p.miss #missing completely at random
X.obs <- X.complete
X.obs[patterns] <- NA
# model selection for SAEM
list.saem.select = model_selection(X.obs,y)
print(list.saem.select$subset_choose)
print(list.saem.select$beta)
}
