% Generated by roxygen2 (4.0.2): do not edit by hand
\name{DTF}
\alias{DTF}
\title{Differential test functioning}
\usage{
DTF(mod, MI = NULL, CI = 0.95, npts = 1000, theta_lim = c(-6, 6),
  Theta_nodes = NULL, plot = FALSE, auto.key = TRUE, ...)
}
\arguments{
\item{mod}{a multipleGroup object which estimated only 2 groups}

\item{MI}{a number indicating how many draws to take to form a suitable multiple imputation
for the expected test scores (100 or more). Requires an estimated parameter
information matrix. Returns a list containing the bootstrap distribution and null hypothesis
test for the sDTF statistic}

\item{CI}{range of confidence interval when using MI input}

\item{npts}{number of points to use in the integration. Default is 1000}

\item{theta_lim}{lower and upper limits of the latent trait (theta) to be evaluated, and is
used in conjunction with \code{npts}}

\item{Theta_nodes}{an optional matrix of Theta values to be evaluated in the MI draws for the
sDTF statistic. However, these values are not averaged across, and instead give the bootstrap
confidence intervals at the respective Theta nodes. Useful when following up a large
uDTF/sDTF statistic to determine where the difference between the test curves are large
(while still accounting for sampling variability). Returns a matrix with observed
variability}

\item{plot}{logical; plot the test score functions with imputed confidence envelopes?}

\item{auto.key}{logical; automatically generate key in lattice plot?}

\item{...}{additional arguments to be passed to lattice}
}
\description{
THIS FUNCTION IS CURRENTLY EXPERIMENTAL.
}
\details{
Function performs various omnibus differential test functioning procedures on an object
estimated with \code{multipleGroup()}. If the latent means/covariances are suspected to differ
then the input object should contain a set of 'anchor' items to ensure that only differential
test features are being detected rather than group differences. Returns signed (average area
above and below) and unsigned (total area) statistics, with descriptives such as the percent
average bias between group total scores for each statistic.
}
\examples{
\dontrun{
set.seed(1234)
n <- 30
N <- 500

# only first 5 items as anchors
model <- mirt.model('F = 1-30
                    CONSTRAINB = (1-5, a1), (1-5, d)')

a <- matrix(1, n)
d <- matrix(rnorm(n), n)
group <- c(rep('G1', N), rep('G2', N))

## -------------
# groups completely equal
dat1 <- simdata(a, d, N, itemtype = 'dich')
dat2 <- simdata(a, d, N, itemtype = 'dich')
dat <- rbind(dat1, dat2)
mod <- multipleGroup(dat, model, group=group, SE=TRUE, SE.type='crossprod',
                     invariance=c('free_means', 'free_var'))
plot(mod, type = 'score')

DTF(mod)
mirtCluster()
DTF(mod, MI = 1000) #95\% C.I. for sDTI containing 0. uDTF is very small

## -------------
## random slopes and intercepts for 15 items, and latent mean difference
##    (no systematic DTF should exist, but DIF will be present)
dat1 <- simdata(a, d, N, itemtype = 'dich', mu=.50, sigma=matrix(1.5))
dat2 <- simdata(a + c(numeric(15), sign(rnorm(n-15))*runif(n-15, .25, .5)),
                d + c(numeric(15), sign(rnorm(n-15))*runif(n-15, .5, 1)), N, itemtype = 'dich')
dat <- rbind(dat1, dat2)
mod1 <- multipleGroup(dat, 1, group=group)
plot(mod1, type = 'score') #does not account for group differences! Need anchors

mod2 <- multipleGroup(dat, model, group=group, SE=TRUE, SE.type = 'crossprod',
                      invariance=c('free_means', 'free_var'))
plot(mod2, type = 'score')

#significant DIF in multiple items....
DIF(mod2, which.par=c('a1', 'd'), items2test=16:30)
DTF(mod2)
DTF(mod2, MI=1000)

## -------------
## systematic differing slopes and intercepts (clear DTF)
dat1 <- simdata(a, d, N, itemtype = 'dich', mu=.50, sigma=matrix(1.5))
dat2 <- simdata(a + c(numeric(15), rnorm(n-15, 1, .25)), d + c(numeric(15), rnorm(n-15, 1, .5)),
                N, itemtype = 'dich')
dat <- rbind(dat1, dat2)
mod3 <- multipleGroup(dat, model, group=group, SE=TRUE, SE.type='crossprod',
                      invariance=c('free_means', 'free_var'))
plot(mod3, type = 'score') #visable DTF happening

DIF(mod3, c('a1', 'd'), items2test=16:30)
DTF(mod3) #unsigned bias. Signed bias indicates group 2 scores generally lower
DTF(mod3, MI=1000)
DTF(mod3, MI=1000, plot=TRUE)

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\seealso{
\code{\link{multipleGroup}}, \code{\link{DIF}}
}
\keyword{DTF}

