% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{launch_local}
\alias{launch_local}
\alias{launch_remote}
\title{Launch Daemon}
\usage{
launch_local(n = 1L, ..., tls = NULL, .compute = NULL)

launch_remote(
  n = 1L,
  remote = remote_config(),
  ...,
  tls = NULL,
  .compute = NULL
)
}
\arguments{
\item{n}{integer number of daemons.

\strong{or} for \code{launch_remote} only, a 'miraiCluster' or 'miraiNode'.}

\item{...}{(optional) arguments passed through to \code{\link[=daemon]{daemon()}}. These include
\code{autoexit}, \code{cleanup}, \code{output}, \code{maxtasks}, \code{idletime} and \code{walltime}.
Only supply to override arguments originally provided to \code{\link[=daemons]{daemons()}},
otherwise those will be used instead.}

\item{tls}{[default NULL] required for secure TLS connections over
'tls+tcp://'. Zero-configuration TLS certificates generated by \code{\link[=daemons]{daemons()}}
are automatically passed to the daemon, without requiring to be specified
here. Otherwise, supply \strong{either} the character path to a file containing
X.509 certificate(s) in PEM format, comprising the certificate authority
certificate chain, \strong{or} a length 2 character vector comprising [i] the
certificate authority certificate chain and [ii] the empty string \code{""}.}

\item{.compute}{[default NULL] character value for the compute profile
to use (each has its own independent set of daemons), or NULL to use the
'default' profile.}

\item{remote}{required only for launching remote daemons, a configuration
generated by \code{\link[=remote_config]{remote_config()}} or \code{\link[=ssh_config]{ssh_config()}}. An empty
\code{\link[=remote_config]{remote_config()}} does not effect any daemon launches but returns the shell
commands for deploying manually on remote machines.}
}
\value{
For \strong{launch_local}: Integer number of daemons launched.

For \strong{launch_remote}: A character vector of daemon launch commands,
classed as 'miraiLaunchCmd'. The printed output may be copy / pasted
directly to the remote machine.
}
\description{
\code{launch_local} spawns a new background \code{Rscript} process calling \code{\link[=daemon]{daemon()}}
with the specified arguments.

\code{launch_remote} returns the shell command for deploying daemons as a
character vector. If a configuration generated by \code{\link[=remote_config]{remote_config()}} or
\code{\link[=ssh_config]{ssh_config()}} is supplied then this is used to launch the daemon on the
remote machine.
}
\details{
These functions may be used to re-launch daemons that have exited after
reaching time or task limits.

Daemons must already be set for launchers to work.

The generated command for non-dispatcher daemons contain the argument \code{rs}
specifying the length 7 L'Ecuyer-CMRG random seed supplied to the daemon. The
values will be different each time the function is called. For dispatcher
daemons, the equivalent random seed is obtained automatically from
dispatcher, and hence \code{rs} is not specified in this case.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
daemons(url = host_url(), dispatcher = FALSE)
status()
launch_local(1L, cleanup = FALSE)
launch_remote(1L, cleanup = FALSE)
Sys.sleep(1)
status()
daemons(0)

daemons(url = host_url(tls = TRUE))
status()
launch_local(2L, output = TRUE)
Sys.sleep(1)
status()
daemons(0)
\dontshow{\}) # examplesIf}
}
