% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{call_mirai}
\alias{call_mirai}
\title{Call mirai (Retrieve Value)}
\usage{
call_mirai(mirai)
}
\arguments{
\item{mirai}{a 'mirai' object.}
}
\value{
The passed mirai (invisibly). The retrieved value is stored in
    \code{$value}.
}
\description{
Retrieve the value of a mirai (waiting for the the asynchronous operation to
    resolve if it is still in progress).
}
\details{
This function will wait for the async operation to complete if it is
    still in progress.

    If an error occured in evaluation, a nul byte \code{00} (or serialized
    nul byte) will be returned.

    The mirai updates itself in place, so do not assign the output of this
    function to avoid duplicates. To access the value of a mirai \code{x}
    directly, use \code{call_mirai(x)$value}.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

mirai <- eval_mirai(x + y + 1, x = 2, y = 3)
mirai
call_mirai(mirai)
mirai
mirai$value

mirai <- eval_mirai(as.matrix(df), df = data.frame())
call_mirai(mirai)$value

mirai <- eval_mirai(rnorm(n), n = 1e6)
call_mirai(mirai)
str(mirai$value)
}

}
