# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

#' Extract Filenames from File Paths
#'
#' @description
#' The `get_filename` function extracts filenames from file paths with options to remove file extensions 
#' and/or directory paths.
#'
#' @param paths A `character` vector containing file system paths.
#'   Must be valid and accessible path strings.
#'
#' @param rm_extension A `logical` flag controlling file extension removal:
#'   - `TRUE`: Strips file extensions from filenames
#'   - `FALSE`: Preserves complete filename with extension
#'   Default is `TRUE`.
#'
#' @param rm_path A `logical` flag managing directory path handling:
#'   - `TRUE`: Extracts only the filename, discarding directory information
#'   - `FALSE`: Retains complete path information
#'   Default is `TRUE`.
#'
#' @details
#' The function performs the following operations:
#' \itemize{
#'   \item Validates input paths
#'   \item Handles empty input vectors
#'   \item Optionally removes directory paths using \code{\link[base]{basename}}
#'   \item Optionally removes file extensions using regex substitution
#' }
#'
#' @return A `character` vector of processed filenames with applied transformations.
#'
#' @note
#' - If both \code{rm_extension} and \code{rm_path} are FALSE, 
#'   a warning is issued and the original paths are returned
#' - Supports multiple file paths in the input vector
#'
#' @seealso
#' \itemize{
#'   \item [`base::basename()`] for basic filename extraction
#' }
#'
#' @export
#' @examples
#' # Example: File path processing demonstrations
#'
#' # Setup test files
#' xlsx_files <- mintyr_example(
#'   mintyr_examples("xlsx_test")    # Get example Excel files
#' )
#'
#' # Example 1: Extract filenames without extensions
#' get_filename(
#'   xlsx_files,                     # Input file paths
#'   rm_extension = TRUE,            # Remove file extensions
#'   rm_path = TRUE                  # Remove directory paths
#' )
#'
#' # Example 2: Keep file extensions
#' get_filename(
#'   xlsx_files,                     # Input file paths
#'   rm_extension = FALSE,           # Keep file extensions
#'   rm_path = TRUE                  # Remove directory paths
#' )
#'
#' # Example 3: Keep full paths without extensions
#' get_filename(
#'   xlsx_files,                     # Input file paths
#'   rm_extension = TRUE,            # Remove file extensions
#'   rm_path = FALSE                 # Keep directory paths
#' )
get_filename <- function(paths, rm_extension = TRUE, rm_path = TRUE) {

  # Input validation
  if (missing(paths)) {
    stop("Parameter 'paths' cannot be empty")
  }

  if (!is.character(paths)) {
    stop("'paths' must be a character vector")
  }

  # Handle empty vector
  if (length(paths) == 0) {
    return(character(0))
  }

  # Warn if both parameters are FALSE
  if (!rm_extension && !rm_path) {
    warning("Setting both rm_extension=FALSE and rm_path=FALSE returns the original paths")
  }

  # Process paths
  result <- if (rm_path) basename(paths) else paths

  # Process extensions
  if (rm_extension) {
    result <- sub("\\.[^.]*$", "", result)
  }

  return(result)
}
