% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_cp.R
\name{mc_cp}
\alias{mc_cp}
\title{Copy files or directories between servers}
\usage{
mc_cp(from, to = "", recursive = FALSE, flags = "", verbose = FALSE)
}
\arguments{
\item{from}{Character string specifying the source file or directory path.
Can accept a vector of file paths as well.}

\item{to}{Character string specifying the destination path.}

\item{recursive}{Logical indicating whether to recursively copy directories.
Default is \code{FALSE}.}

\item{flags}{any additional flags to \code{cp}}

\item{verbose}{Logical indicating whether to report files copied.
Default is \code{FALSE}.}
}
\value{
Returns the list from \code{\link[processx:run]{processx::run()}}, with components \code{status},
\code{stdout}, \code{stderr}, and \code{timeout}; invisibly.
}
\description{
Most commonly used to upload and download files between local filesystem
and remote S3 store.
}
\details{
see \code{mc("cp -h")} for details.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Copy a file
mc_cp("local/path/to/file.txt", "alias/bucket/path/file.txt")

# Copy a directory recursively
mc_cp("local/directory", "alias/bucket/path/to/directory", recursive = TRUE)

\dontshow{\}) # examplesIf}
}
\seealso{
\code{mc_mirror}
}
