% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{close_centrality}
\alias{close_centrality}
\alias{node_closeness}
\alias{node_reach}
\alias{tie_closeness}
\alias{network_closeness}
\title{Measures of closeness-like centrality and centralisation}
\usage{
node_closeness(.data, normalized = TRUE, direction = "out", cutoff = NULL)

node_reach(.data, normalized = TRUE, k = 2)

tie_closeness(.data, normalized = TRUE)

network_closeness(.data, normalized = TRUE, direction = c("all", "out", "in"))
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{direction}{Character string, “out” bases the measure on outgoing ties,
“in” on incoming ties, and "all" on either/the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that mode.}

\item{cutoff}{Maximum path length to use during calculations.}

\item{k}{Integer of steps out to calculate reach}
}
\description{
Measures of closeness-like centrality and centralisation
}
\section{Functions}{
\itemize{
\item \code{node_closeness()}: Calculate the closeness centrality of nodes in a network

\item \code{node_reach()}: Calculate nodes' reach centrality
or how many nodes they can reach within \emph{k} steps

\item \code{tie_closeness()}: Calculate the closeness of each edge to each other edge
in the network.

\item \code{network_closeness()}: Calculate the closeness centralization for a graph

}}
\examples{
node_closeness(mpn_elite_mex)
node_closeness(ison_southern_women)
node_reach(ison_adolescents)
(ec <- tie_closeness(ison_adolescents))
plot(ec)
ison_adolescents \%>\% 
  activate(edges) \%>\% mutate(weight = ec) \%>\% 
  autographr()
network_closeness(ison_southern_women, direction = "in")
}
\seealso{
Other measures: 
\code{\link{between_centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{features}},
\code{\link{heterogeneity}},
\code{\link{holes}}

Other centrality: 
\code{\link{between_centrality}},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}}
}
\concept{centrality}
\concept{measures}
