% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{coercion}
\alias{coercion}
\alias{as_edgelist}
\alias{as_matrix}
\alias{as_igraph}
\alias{as_tidygraph}
\alias{as_network}
\title{Coercion between graph/network object classes}
\usage{
as_edgelist(object, weight = FALSE)

as_matrix(object, weight = FALSE)

as_igraph(object, weight = FALSE, twomode = FALSE)

as_tidygraph(object, twomode = FALSE)

as_network(object)
}
\arguments{
\item{object}{A data frame edgelist, matrix, igraph, tidygraph, or
network object.}

\item{weight}{An option to override the heuristics for distinguishing
weighted networks. By default FALSE.}

\item{twomode}{An option to override the heuristics for distinguishing
incidence from adjacency matrices. By default FALSE.}
}
\value{
The currently implemented coercions or translations are:\tabular{lccccc}{
   to/from \tab edgelists \tab matrices \tab igraph \tab tidygraph \tab network \cr
   edgelists (data frames) \tab  \tab X \tab X \tab X \tab X \cr
   matrices \tab X \tab X \tab X \tab X \tab X \cr
   igraph \tab X \tab X \tab X \tab X \tab X \cr
   tidygraph \tab X \tab X \tab X \tab X \tab X \cr
   network \tab X \tab X \tab X \tab X \tab X \cr
}
}
\description{
The \code{as_} functions in \code{{migraph}} coerce objects
between several common classes of social network objects.
These include:
\itemize{
\item adjacency and incidence matrices
\item edgelists (as data frames)
\item \code{{igraph}} \code{graph} objects
\item \code{{tidygraph}} \code{tbl_graph} objects
\item \code{{network}} \code{network} objects
}
}
\details{
Behaviour is a little different depending on the data format.

If the data frame is a 2 column edgelist,
the first column will become the rows
and the second column will become the columns.
If the data frame is a 3 column edgelist,
then the third column will be used as
the cell values or tie weights.

Incidence matrices are typically inferred from unequal dimensions,
but since in rare cases a matrix with equal dimensions may still
be an incidence matrix, an additional argument \code{twomode} can be
specified to override this heuristic.
This information is usually already embedded in \code{{igraph}},
\code{{tidygraph}}, and \code{{network}} objects.
}
\examples{
test <- data.frame(id1 = c("A","B","B","C","C"),
                   id2 = c("I","G","I","G","H"))
as_matrix(test)
as_igraph(test)
as_tidygraph(test)
as_network(test)
}
\seealso{
Other manipulation: 
\code{\link{is}()},
\code{\link{project}},
\code{\link{to}}
}
\concept{manipulation}
