% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gglineage.R
\name{gglineage}
\alias{gglineage}
\title{Plot lineage graph}
\usage{
gglineage(object, labels = TRUE)
}
\arguments{
\item{object}{A migraph-consistent network/graph.}

\item{labels}{Whether to plot node labels or not. Default: TRUE.}
}
\description{
Lineage implies a direct descent from an ancestor; ancestry or pedigree.
That is, how observation derives and is connected to previous observations.
The function plots a lineage graph of citations, amendments, and more, for example.
}
\examples{
cites <- tibble::tibble(qID1 = c("BNLHPB_2016P:BNLHPB_1970A",
"PARIS_2015A","INOOTO_2015A", "RUS-USA[UUF]_2015A",
"RUS-USA[UUF]_2015A", "RUS-USA[UUF]_2015A", "RUS-USA[UUF]_2015A",
"INECHA_2015O", "ST04DC_2014P", "ST04DC_2014P"),
qID2 = c("BNLHPB_1977P:BNLHPB_1970A", "UNFCCC_1992A", "INOOTO_2005A",
"RUS-USA[MFR]_1988A", "PS07UF_2009A", "UNCLOS_1982A", "UNCLOS_1982A",
"ERECHA_1991O", "AI07EM_1998A", "CNEWNH_1979A"))
gglineage(cites)
}
